/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantComparatorByName;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.translation.Translation;

public class PlantComponent
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Garden.class.getName());
    public Plant plant;

    public PlantComponent() {
    }

    public PlantComponent(Plant plant) {
        this.setPlant(plant);
    }

    public void setPlant(Plant plant) {
        this.plant = plant;
        try {
            ImageIcon imageIcon = new ImageIcon(plant.getImage().get().getScaledInstance(12, 12, 4));
            this.setIcon(imageIcon);
        }
        catch (Exception exception) {
            System.err.println("PlantComponent: Cannot set icon for " + plant.getName() + " " + exception.toString());
        }
        this.setText(Translation.getPreferred().translate(plant));
        this.setBorder(BorderFactory.createEtchedBorder());
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.setToolTipText(this.getHtmlToolTipText());
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 10, 0, 10)));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    private String getHtmlToolTipText() {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><center><h2>");
        stringBuilder.append(translation.translate(this.plant));
        stringBuilder.append("</h2><i>");
        stringBuilder.append(this.plant.getName());
        stringBuilder.append("</i></center>");
        ArrayList<Plant> arrayList = new ArrayList<Plant>();
        ArrayList<Plant> arrayList2 = new ArrayList<Plant>();
        Plant plant = this.plant;
        do {
            PlantComponent.getCompanionPlants(plant, arrayList, arrayList2);
        } while ((plant = plant.getParent()) != null && plant.getType() != Taxon.Type.GENUS && plant.getType() != Taxon.Type.FAMILY);
        Plant plant2 = plant.getType() == Taxon.Type.GENUS ? plant : null;
        ArrayList<Plant> arrayList3 = new ArrayList<Plant>();
        ArrayList<Plant> arrayList4 = new ArrayList<Plant>();
        if (plant2 != null) {
            PlantComponent.getCompanionPlants(plant2, arrayList3, arrayList4);
            PlantComponent.removeDuplicated(arrayList3, arrayList);
            PlantComponent.removeDuplicated(arrayList4, arrayList2);
        }
        Plant plant3 = (Plant)this.plant.getFamily();
        ArrayList<Plant> arrayList5 = new ArrayList<Plant>();
        ArrayList<Plant> arrayList6 = new ArrayList<Plant>();
        PlantComponent.getCompanionPlants(plant3, arrayList5, arrayList6);
        PlantComponent.removeDuplicated(arrayList5, arrayList);
        PlantComponent.removeDuplicated(arrayList6, arrayList2);
        PlantComponent.removeDuplicated(arrayList5, arrayList3);
        PlantComponent.removeDuplicated(arrayList6, arrayList4);
        stringBuilder.append("<table border='0'>");
        if (!(arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty() && arrayList4.isEmpty() && arrayList5.isEmpty() && arrayList6.isEmpty())) {
            stringBuilder.append("<tr><th>");
            stringBuilder.append(translation.companion_good());
            stringBuilder.append("</th><th>");
            stringBuilder.append(translation.companion_bad());
            stringBuilder.append("</th></tr>");
        }
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            stringBuilder.append("<tr align='center'><td colspan='2'><hr/></td></tr>");
            PlantComponent.getTooltips(stringBuilder, arrayList, arrayList2);
        }
        if (!arrayList3.isEmpty() || !arrayList4.isEmpty()) {
            stringBuilder.append("<tr align='center'><td colspan='2'><hr/></td></tr>");
            stringBuilder.append("<tr align='center'><td colspan='2'><b>");
            stringBuilder.append(plant2.getName());
            stringBuilder.append("</b></td></tr>");
            PlantComponent.getTooltips(stringBuilder, arrayList3, arrayList4);
        }
        stringBuilder.append("<tr align='center'><td colspan='2'><hr/></td></tr>");
        stringBuilder.append("<tr><td colspan='2' align='center'>");
        stringBuilder.append("<b>").append(translation.translate(plant3)).append("</b> - ").append(plant3.getName());
        stringBuilder.append("</td></tr>");
        PlantComponent.getTooltips(stringBuilder, arrayList5, arrayList6);
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private static void removeDuplicated(ArrayList<Plant> arrayList, ArrayList<Plant> arrayList2) {
        block0: for (Plant plant : arrayList2) {
            for (Plant plant2 : arrayList) {
                if (plant2 != plant && !plant.isParentOf(plant2) && !plant2.isParentOf(plant)) continue;
                arrayList.remove(plant2);
                continue block0;
            }
        }
    }

    private static void getTooltips(StringBuilder stringBuilder, ArrayList<Plant> arrayList, ArrayList<Plant> arrayList2) {
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return;
        }
        stringBuilder.append("<tr><td align='left' valign='top'>");
        PlantComponent.listToTooltip(stringBuilder, arrayList);
        stringBuilder.append("</td>");
        stringBuilder.append("<td align='left' valign='top'>");
        PlantComponent.listToTooltip(stringBuilder, arrayList2);
        stringBuilder.append("</td></tr>");
    }

    private static void getCompanionPlants(Plant plant, ArrayList<Plant> arrayList, ArrayList<Plant> arrayList2) {
        for (Companion companion : plant.getCompanions().get()) {
            ArrayList<Plant> arrayList3 = companion.type.isBeneficial() ? arrayList : arrayList2;
            boolean bl = false;
            for (Plant plant2 : arrayList3) {
                if (plant2 != companion.plant && !plant2.isParentOf(companion.plant)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ArrayList arrayList4 = new ArrayList();
            for (Plant plant3 : arrayList3) {
                if (!companion.plant.isParentOf(plant3)) continue;
                arrayList4.add(plant3);
            }
            Iterator iterator = arrayList4.iterator();
            while (iterator.hasNext()) {
                Plant plant3;
                plant3 = (Plant)iterator.next();
                arrayList3.remove(plant3);
            }
            arrayList3.add(companion.plant);
        }
        Collections.sort(arrayList, new PlantComparatorByName());
        Collections.sort(arrayList2, new PlantComparatorByName());
    }

    private static void listToTooltip(StringBuilder stringBuilder, ArrayList<Plant> arrayList) {
        Translation translation = Translation.getPreferred();
        boolean bl = true;
        for (Plant plant : arrayList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("<br>");
            }
            if (plant.getChildren().size() == 1) {
                stringBuilder.append(translation.translate(plant.getChildren().iterator().next()));
                continue;
            }
            stringBuilder.append(translation.translate(plant));
            if (plant.getChildren().size() == 0) continue;
            ArrayList<Plant> arrayList2 = new ArrayList<Plant>();
            PlantComponent.getAllChildren(plant, arrayList2);
            Collections.sort(arrayList2, new PlantComparatorByName());
            for (Plant plant2 : arrayList2) {
                stringBuilder.append("<br>");
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                stringBuilder.append(translation.translate(plant2));
            }
        }
    }

    private static void getAllChildren(Plant plant, ArrayList<Plant> arrayList) {
        if (plant.getChildren().size() == 0) {
            arrayList.add(plant);
        } else {
            for (Taxon taxon : plant.getChildren()) {
                PlantComponent.getAllChildren((Plant)taxon, arrayList);
            }
        }
    }
}

