/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.gui.desktop.PlantLabel;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.Lifetime;
import org.sourceforge.kga.translation.Translation;

public class PlantProperties
extends JPanel {
    private static final long serialVersionUID = 1L;

    String getLifetimeText(Lifetime lifetime) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(lifetime.translate());
        if (lifetime.get() != Lifetime.Value.PERENNIAL && lifetime.getRepetitionYears() != 1 || lifetime.get() == Lifetime.Value.PERENNIAL && lifetime.getRepetitionYears() != Integer.MAX_VALUE) {
            stringBuilder.append(" ");
            stringBuilder.append(translation.allowed_repetitions());
            stringBuilder.append("=");
            stringBuilder.append(lifetime.getRepetitionYears());
            stringBuilder.append(" ");
            stringBuilder.append(lifetime.getRepetitionYears() == 1 ? translation.year().toLowerCase() : translation.years());
        }
        if (lifetime.getRepetitionYears() != Integer.MAX_VALUE) {
            stringBuilder.append(" ");
            stringBuilder.append(translation.repetition_gap());
            stringBuilder.append("=");
            stringBuilder.append(lifetime.getRepetitionGap());
            stringBuilder.append(" ");
            stringBuilder.append(lifetime.getRepetitionGap() == 1 ? translation.year().toLowerCase() : translation.years());
        }
        return stringBuilder.toString();
    }

    public void loadPlant(Plant plant) {
        this.removeAll();
        if (plant == null) {
            return;
        }
        Translation translation = Translation.getPreferred();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        JLabel jLabel = new JLabel(translation.translate(plant));
        JLabel jLabel2 = new JLabel(plant.getName());
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel(translation.family() + " " + translation.translate(plant.getFamily()));
        JLabel jLabel5 = new JLabel(this.getLifetimeText(plant.lifetime));
        Font font = this.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize() + 4));
        jLabel2.setFont(new Font(font.getName(), 2, font.getSize()));
        jLabel4.setFont(new Font(font.getName(), 0, font.getSize()));
        jLabel5.setFont(new Font(font.getName(), 0, font.getSize()));
        if (plant.getImage() != null) {
            jLabel3.setIcon(new ImageIcon(plant.getImage().get().getScaledInstance(72, 72, 4)));
        }
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
        parallelGroup2.addComponent(jLabel);
        parallelGroup2.addComponent(jLabel2);
        parallelGroup2.addComponent(jLabel4);
        parallelGroup2.addComponent(jLabel5);
        sequentialGroup.addGroup(parallelGroup2);
        sequentialGroup.addComponent(jLabel3);
        parallelGroup.addGroup(sequentialGroup);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup3 = groupLayout.createParallelGroup();
        GroupLayout.SequentialGroup sequentialGroup3 = groupLayout.createSequentialGroup();
        sequentialGroup3.addComponent(jLabel);
        sequentialGroup3.addComponent(jLabel2);
        sequentialGroup3.addComponent(jLabel4);
        sequentialGroup3.addComponent(jLabel5);
        parallelGroup3.addGroup(sequentialGroup3);
        parallelGroup3.addComponent(jLabel3);
        sequentialGroup2.addGroup(parallelGroup3);
        for (Companion.Type type : Companion.Type.values()) {
            JLabel jLabel6 = null;
            switch (type) {
                case GOOD: {
                    jLabel6 = new JLabel(translation.companion_good());
                    break;
                }
                case IMPROVE: {
                    jLabel6 = new JLabel(translation.companion_improve());
                    break;
                }
                case BAD: {
                    jLabel6 = new JLabel(translation.companion_bad());
                    break;
                }
                case INHIBIT: {
                    jLabel6 = new JLabel(translation.companion_inhibit());
                    break;
                }
                case ATTRACT_PEST: {
                    jLabel6 = new JLabel(translation.companion_attract_pest());
                    break;
                }
                case REPEL_PEST: {
                    jLabel6 = new JLabel(translation.companion_repel_pest());
                    break;
                }
                case ATTRACT_BENEFICIAL: {
                    jLabel6 = new JLabel(translation.companion_attract_beneficial());
                    break;
                }
                case REPEL_BENEFICIAL: {
                    jLabel6 = new JLabel(translation.companion_repel_beneficial());
                    break;
                }
                case TRAP_PEST: {
                    jLabel6 = new JLabel(translation.companion_trap_pest());
                }
            }
            ArrayList<Companion> arrayList = new ArrayList<Companion>();
            for (Companion companion : plant.getCompanions().getInherited()) {
                if (companion.type != type) continue;
                arrayList.add(companion);
            }
            if (arrayList.size() == 0) continue;
            parallelGroup.addComponent(jLabel6);
            sequentialGroup2.addComponent(jLabel6);
            JPanel jPanel = new JPanel(new GridLayout(0, 8));
            for (Companion companion : arrayList) {
                jPanel.add(new PlantLabel(companion.plant));
            }
            parallelGroup.addComponent(jPanel);
            sequentialGroup2.addComponent(jPanel);
        }
        groupLayout.setHorizontalGroup(parallelGroup);
        groupLayout.setVerticalGroup(sequentialGroup2);
    }
}

