/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.time.LocalDate;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.gui.desktop.FileWithChanges;
import org.sourceforge.kga.io.SeedListFormatV1;

public class SeedFileWithChanges
extends FileWithChanges
implements SeedList.Listener {
    SeedList seedInventory;
    SeedList seedShoppingList;
    LocalDate date;

    public SeedFileWithChanges() {
        super("/org/sourceforge/kga/gui/seedManager", "Kitchen garden aid - seeds", "seed");
    }

    public SeedList getSeedShoppingList() {
        return this.seedShoppingList;
    }

    public SeedList getSeedInventory() {
        return this.seedInventory;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
        if (this.seedInventory != null) {
            this.seedInventory.setDate(localDate);
            this.seedShoppingList.setDate(localDate);
        }
    }

    private void setLists(SeedList seedList, SeedList seedList2) {
        if (this.seedInventory != null) {
            this.seedInventory.removeListener(this);
            this.seedShoppingList.removeListener(this);
        }
        this.seedInventory = seedList;
        this.seedShoppingList = seedList2;
        this.seedInventory.setDate(this.date);
        this.seedShoppingList.setDate(this.date);
        this.seedInventory.addListener(this);
        this.seedShoppingList.addListener(this);
    }

    @Override
    public void createObjects() {
        this.setLists(new SeedList(), new SeedList());
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        SeedList seedList = new SeedList();
        SeedList seedList2 = new SeedList();
        SeedListFormatV1 seedListFormatV1 = new SeedListFormatV1();
        seedListFormatV1.load(seedList, seedList2, inputStream);
        this.setLists(seedList, seedList2);
    }

    @Override
    public void saveToFile() throws Exception {
        SeedListFormatV1 seedListFormatV1 = new SeedListFormatV1();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        seedListFormatV1.save(this.seedInventory, this.seedShoppingList, dataOutputStream);
        dataOutputStream.close();
    }

    @Override
    public void viewChanged() {
    }

    @Override
    public void listChanged() {
        this.setUnsavedChanges();
    }
}

