/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.Export;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Translation;

public class ExportTranslation
extends KgaAction {
    private static Logger log = Logger.getLogger(Export.class.getName());

    public ExportTranslation(Gui gui) {
        super(gui, Translation.getPreferred().action_export_translation());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mailto:tiberius.duluman@gmail.com?subject=Translation%20update&body=");
        try {
            Serializable serializable;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(byteArrayOutputStream, "UTF-8");
            xMLStreamWriter.writeStartDocument("UTF-8", "1.0");
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement("translations");
            xMLStreamWriter.writeCharacters("\n");
            for (String object2 : Translation.getLanguages()) {
                serializable = Translation.getTranslation(object2).getCustomTranslations();
                if (((Properties)serializable).isEmpty()) continue;
                xMLStreamWriter.writeStartElement("translation");
                xMLStreamWriter.writeAttribute("xml:lang", object2);
                xMLStreamWriter.writeCharacters("\n");
                ArrayList<String> arrayList = new ArrayList<String>();
                Translation.Key[] keyArray = Translation.Key.values();
                block3: for (Object object : ((Properties)serializable).keySet()) {
                    for (int i = 0; i < keyArray.length; ++i) {
                        if (keyArray[i].name().compareTo(object.toString()) != 0) continue;
                        arrayList.add(object.toString());
                        continue block3;
                    }
                }
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    xMLStreamWriter.writeStartElement("entry");
                    xMLStreamWriter.writeAttribute("key", string);
                    xMLStreamWriter.writeCharacters(((Properties)serializable).get(string).toString());
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeCharacters("\n");
                }
                ArrayList<Integer> arrayList2 = new ArrayList();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                block6: for (Object object : ((Properties)serializable).keySet()) {
                    boolean bl = false;
                    for (Plant plant : PlantList.getResources().getPlants()) {
                        if (object.toString().compareTo(plant.getName()) != 0) continue;
                        (plant.getType() == Taxon.Type.FAMILY ? arrayList2 : arrayList3).add(plant.getId());
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    for (Animal animal : PlantList.getResources().getAnimals()) {
                        if (object.toString().compareTo(animal.getName()) != 0) continue;
                        arrayList4.add(animal.getId());
                        bl = true;
                        continue block6;
                    }
                }
                Collections.sort(arrayList2);
                Collections.sort(arrayList3);
                Collections.sort(arrayList4);
                for (int i = 0; i < 3; ++i) {
                    Object object;
                    object = i == 0 ? arrayList2 : (i == 1 ? arrayList3 : arrayList4);
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        Taxon taxon = i == 2 ? PlantList.getResources().getAnimal(n) : PlantList.getResources().getPlant(n);
                        xMLStreamWriter.writeStartElement("name");
                        xMLStreamWriter.writeAttribute("id", Integer.toString(n));
                        xMLStreamWriter.writeCharacters(((Properties)serializable).get(taxon.getName()).toString());
                        xMLStreamWriter.writeEndElement();
                        xMLStreamWriter.writeCharacters("\n");
                    }
                }
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeCharacters("\n");
            }
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            log.info("Export translation succeed");
            JTextArea jTextArea = new JTextArea();
            jTextArea.append("Send content below to\n");
            jTextArea.append("tiberius.duluman@gmail.com\n");
            jTextArea.append("https://www.facebook.com/kitchengardenaid\n");
            jTextArea.append("\n");
            jTextArea.append(byteArrayOutputStream.toString("UTF-8"));
            jTextArea.setBorder(BorderFactory.createEtchedBorder());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            serializable = new JOptionPane(jScrollPane).createDialog(Translation.getPreferred().action_export_translation());
            jScrollPane.getVerticalScrollBar().setValue(0);
            jScrollPane.getHorizontalScrollBar().setValue(0);
            ((Dialog)serializable).setVisible(true);
        }
        catch (Exception exception) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.getGui(), exception.toString(), translation.error_saving_file(), 0);
        }
    }
}

