/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions.importData;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.gui.desktop.actions.importData.DataTableModel;
import org.sourceforge.kga.gui.desktop.actions.importData.SourceTableModel;
import org.sourceforge.kga.gui.desktop.actions.importData.TagTableModel;
import org.sourceforge.kga.gui.desktop.actions.importData.TaggedPlantsTableModel;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.NutritionalNeeds;
import org.sourceforge.kga.plant.PropertySource;
import org.sourceforge.kga.plant.Reference;
import org.sourceforge.kga.plant.RootDeepness;
import org.sourceforge.kga.plant.WeedControl;

public class CsvParser {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    ArrayList<PropertySource> sources = new ArrayList();
    TreeMap<String, ArrayList<String>> tags = new TreeMap();
    ArrayList<String> columns = new ArrayList();
    int pageColumn;
    int nameColumn;
    int companionColumn;
    int rootColumn;
    int nutritionalColumn;
    int weedColumn;
    ArrayList<List<String>> values = new ArrayList();
    TreeMap<Integer, TreeMap<Integer, String>> errors = new TreeMap();
    SourceTableModel sourceModel;
    TagTableModel tagModel;
    TaggedPlantsTableModel taggedPlantsModel;
    DataTableModel dataModel;

    public void loadFile(File file) throws Exception {
        this.sources.clear();
        this.columns.clear();
        this.values.clear();
        BufferedReader bufferedReader = null;
        try {
            String string;
            int n;
            Object object;
            log.info("importing");
            bufferedReader = new BufferedReader(new FileReader(file));
            String[] stringArray = this.readAndSplitLine(bufferedReader);
            while (stringArray[0].compareTo("source") == 0) {
                object = new PropertySource(this.sources.size() + 1, stringArray[1], stringArray.length == 2 ? "" : stringArray[2]);
                this.sources.add((PropertySource)object);
                stringArray = this.readAndSplitLine(bufferedReader);
            }
            while (stringArray[0].compareTo("tag") == 0) {
                log.finest("Tag parsed " + stringArray[1]);
                object = Arrays.asList(stringArray).subList(2, stringArray.length);
                this.tags.put(stringArray[1], new ArrayList(object));
                stringArray = this.readAndSplitLine(bufferedReader);
            }
            this.columns.addAll(Arrays.asList(stringArray));
            this.pageColumn = -1;
            this.companionColumn = -1;
            this.rootColumn = -1;
            this.nutritionalColumn = -1;
            this.weedColumn = -1;
            this.nameColumn = 0;
            if (this.sources.size() > 1) {
                if (this.columns.get(this.nameColumn).compareTo("ref") != 0) {
                    throw new Exception("First column must be ref; found " + this.columns.get(this.nameColumn));
                }
                ++this.nameColumn;
            }
            if (this.columns.get(this.nameColumn).compareTo("page") == 0) {
                this.pageColumn = this.nameColumn++;
            }
            if (this.columns.get(this.nameColumn).compareTo("name") != 0) {
                throw new Exception("First column must be name; found " + this.columns.get(this.nameColumn));
            }
            for (n = this.nameColumn + 1; n < this.columns.size(); ++n) {
                if (this.columns.get(n).compareTo("companion_type") == 0) {
                    int n2;
                    if (this.columns.get(n + 1).compareTo("companion_name") != 0) {
                        throw new Exception("Expected column: companion_name; found: " + this.columns.get(n + 1));
                    }
                    if (this.columns.get(n + 2).compareTo("companion_effect") == 0) {
                        n2 = 0;
                    } else {
                        if (this.columns.get(n + 2).compareTo("companion_scientific") != 0) {
                            throw new Exception("Expected column: companion_scientific or companion_effect; found: " + this.columns.get(n + 2));
                        }
                        n2 = 1;
                    }
                    if (this.columns.get(n + 3 + n2).compareTo("companion_info") != 0) {
                        throw new Exception("Expected column: companion_info; found: " + this.columns.get(n + 3 + n2));
                    }
                    this.companionColumn = n;
                    continue;
                }
                if (this.columns.get(n).compareTo("root") == 0) {
                    this.rootColumn = n;
                    continue;
                }
                if (this.columns.get(n).compareTo("nutritional") == 0) {
                    this.nutritionalColumn = n;
                    continue;
                }
                if (this.columns.get(n).compareTo("weed") != 0) continue;
                this.weedColumn = n;
            }
            n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(string.split("[\t]")));
                if (arrayList.size() > this.columns.size()) {
                    throw new Exception("Too many values on row: " + Integer.toString(n) + "\n" + string);
                }
                while (arrayList.size() < this.columns.size()) {
                    arrayList.add("");
                }
                this.values.add(arrayList);
                for (int i = 0; i < this.columns.size(); ++i) {
                    this.checkForErrors(n, i);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        this.sourceModel = new SourceTableModel(this);
        this.tagModel = new TagTableModel(this);
        this.taggedPlantsModel = new TaggedPlantsTableModel(this);
        this.dataModel = new DataTableModel(this);
    }

    private static Plant findByName(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (Plant plant : PlantList.getResources().getPlants()) {
            String string2;
            if (!(bl ? plant.getName().compareTo(string) == 0 : (string2 = plant.getTranslation("en")) != null && !string2.isEmpty() && string2.compareTo(string) == 0)) continue;
            return plant;
        }
        return null;
    }

    private static Plant findPlant(String string) {
        log.fine("find plant " + string);
        Plant plant = CsvParser.findByName(string, false);
        if (plant != null) {
            return plant;
        }
        return CsvParser.findByName(string, true);
    }

    private static Animal findAnimalByName(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (Animal animal : PlantList.getResources().getAnimals()) {
            String string2;
            if (!(bl ? animal.getName().compareTo(string) == 0 : (string2 = animal.getTranslation("en")) != null && !string2.isEmpty() && string2.compareTo(string) == 0)) continue;
            return animal;
        }
        return null;
    }

    private static Animal findAnimal(String string) {
        log.fine("find animal " + string);
        Animal animal = CsvParser.findAnimalByName(string, false);
        if (animal != null) {
            return animal;
        }
        return CsvParser.findAnimalByName(string, true);
    }

    private static Plant findPlant(String string, String string2) throws Exception {
        String string3;
        log.fine("find plant " + string + " " + string2);
        Plant plant = CsvParser.findByName(string, false);
        Plant plant2 = CsvParser.findByName(string2, true);
        if (plant != null && plant2 != null && plant != plant2) {
            throw new Exception("Found different plants for " + string + " " + string2);
        }
        if (plant != null && !string2.isEmpty() && plant.getName().compareTo(string2) != 0) {
            throw new Exception("Invalid scientific name for " + string + ": " + string2);
        }
        if (!(plant2 == null || string.isEmpty() || (string3 = plant2.getTranslation("en")) != null && string3.compareTo(string) == 0)) {
            throw new Exception("Invalid name for " + string2 + ": " + string);
        }
        return plant != null ? plant : plant2;
    }

    private Set<Plant> findTaggedPlants(String string) {
        ArrayList<String> arrayList = this.tags.get(string);
        if (arrayList == null) {
            return null;
        }
        log.fine("Parsing tag " + string);
        HashSet<Plant> hashSet = new HashSet<Plant>();
        for (String string2 : arrayList) {
            log.fine("Parsing plant in tag " + string2);
            Plant plant = null;
            try {
                plant = CsvParser.findPlant(string2, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (plant == null) {
                try {
                    plant = CsvParser.findPlant("", string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (plant != null) {
                log.fine("Plant with tag found ");
                hashSet.add(plant);
                continue;
            }
            log.fine("Plant with tag not found ");
        }
        return hashSet;
    }

    public void checkForErrors(int n, int n2) {
        List<String> list = this.values.get(n);
        TreeMap<Integer, String> treeMap = this.errors.get(n);
        try {
            while (n2 >= 0) {
                if (treeMap != null) {
                    treeMap.remove(n2);
                }
                if (n2 == this.companionColumn) {
                    this.parseColumnCompanion(list);
                    break;
                }
                if (n2 == this.rootColumn) {
                    this.parseColumnRoot(list);
                    break;
                }
                if (n2 == this.nutritionalColumn) {
                    this.parseColumnNutritional(list);
                    break;
                }
                if (n2 == this.weedColumn) {
                    this.parseColumnWeedControl(list);
                    break;
                }
                if (n2 == this.nameColumn) {
                    this.parseColumnPlant(list, this.nameColumn, this.columns.get(this.nameColumn + 1).compareTo("scientific") == 0);
                    break;
                }
                if (n2 == 0) {
                    this.parseColumnReference(list);
                    break;
                }
                --n2;
            }
        }
        catch (ParseException parseException) {
            if (treeMap == null) {
                treeMap = new TreeMap();
                this.errors.put(n, treeMap);
            }
            treeMap.put(parseException.getColumn(), parseException.getMessage());
        }
    }

    private String[] readAndSplitLine(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new Exception("Can not read line");
        }
        return string.split("[\t]");
    }

    Reference parseColumnReference(List<String> list) {
        int n = 0;
        String string = null;
        if (this.columns.get(0).compareTo("ref") == 0) {
            n = Integer.parseInt(list.get(0)) - 1;
        }
        PropertySource propertySource = this.sources.get(n);
        propertySource = PlantList.getResources().addSource(propertySource.name, propertySource.url);
        if (this.pageColumn != -1 && !list.get(this.pageColumn).isEmpty()) {
            string = list.get(this.pageColumn);
        }
        return new Reference(propertySource, string);
    }

    Set<Plant> parseColumnPlant(List<String> list, int n, boolean bl) throws ParseException {
        Plant plant;
        String string = list.get(n);
        if (bl) {
            try {
                plant = CsvParser.findPlant(string, list.get(n + 1));
            }
            catch (Exception exception) {
                throw new ParseException(n, exception.getMessage());
            }
        } else {
            plant = CsvParser.findPlant(string);
        }
        if (plant != null) {
            HashSet<Plant> hashSet = new HashSet<Plant>();
            hashSet.add(plant);
            return hashSet;
        }
        Set<Plant> set = this.findTaggedPlants(string);
        if (set != null) {
            return set;
        }
        if (bl && !list.get(n + 1).isEmpty()) {
            throw new ParseException(n, "Can not find plant " + string + " ( " + list.get(n + 1) + " )");
        }
        throw new ParseException(n, "Can not find plant " + string);
    }

    ParsedCompanion parseColumnCompanion(List<String> list) throws ParseException {
        ParsedCompanion parsedCompanion;
        block18: {
            String string;
            int n;
            block17: {
                parsedCompanion = new ParsedCompanion();
                boolean bl = this.columns.get(this.companionColumn + 2).compareTo("companion_scientific") == 0;
                String string2 = list.get(this.companionColumn);
                if (string2.compareTo("help") != 0 && string2.compareTo("help eachother") != 0 && string2.compareTo("like") != 0 && string2.compareTo("like eachother") != 0 && string2.compareTo("inhibit") != 0 && string2.compareTo("inhibit eachother") != 0 && string2.compareTo("dislike") != 0 && string2.compareTo("dislike eachother") != 0) {
                    throw new ParseException(this.companionColumn, "Invalid companion type " + string2);
                }
                parsedCompanion.eachOther = string2.compareTo("help eachother") == 0 || string2.compareTo("like eachother") == 0 || string2.compareTo("inhibit eachother") == 0 || string2.compareTo("dislike eachother") == 0;
                parsedCompanion.companions = this.parseColumnPlant(list, this.companionColumn + 1, bl);
                parsedCompanion.addToCompanions = string2.compareTo("help") == 0 || string2.compareTo("inhibit") == 0;
                parsedCompanion.type = string2.startsWith("help") || string2.startsWith("like") ? Companion.Type.GOOD : Companion.Type.BAD;
                int n2 = this.companionColumn + 2 + (bl ? 1 : 0);
                String string3 = list.get(n2);
                if (string3.compareTo("repel") == 0) {
                    parsedCompanion.type = parsedCompanion.type == Companion.Type.BAD ? Companion.Type.REPEL_BENEFICIAL : Companion.Type.REPEL_PEST;
                } else if (string3.compareTo("attract") == 0) {
                    parsedCompanion.type = parsedCompanion.type == Companion.Type.BAD ? Companion.Type.ATTRACT_PEST : Companion.Type.ATTRACT_BENEFICIAL;
                } else if (string3.compareTo("improve") == 0) {
                    parsedCompanion.type = Companion.Type.IMPROVE;
                } else if (string3.compareTo("trap") == 0) {
                    parsedCompanion.type = Companion.Type.TRAP_PEST;
                } else if (string2.compareTo("inhibit") == 0 || string2.compareTo("inhibit eachother") == 0) {
                    parsedCompanion.type = Companion.Type.INHIBIT;
                } else if (string3.compareTo("") != 0) {
                    throw new ParseException(n2, "Invalid companion effect: " + string3);
                }
                n = this.companionColumn + 3 + (bl ? 1 : 0);
                string = list.get(n);
                if (parsedCompanion.type != Companion.Type.IMPROVE) break block17;
                for (String string4 : string.split(",")) {
                    try {
                        Companion.Improve improve = Companion.Improve.valueOf(string4.trim().toUpperCase().replace(' ', '_'));
                        parsedCompanion.improve.add(improve);
                    }
                    catch (Exception exception) {
                        throw new ParseException(n, exception.getMessage());
                    }
                }
                break block18;
            }
            if (!parsedCompanion.type.withAnimals()) break block18;
            for (String string5 : string.split(",")) {
                Animal animal = CsvParser.findAnimal(string5.trim());
                if (animal == null) {
                    throw new ParseException(n, string5.trim() + " not found");
                }
                parsedCompanion.animals.add(animal);
            }
        }
        return parsedCompanion;
    }

    RootDeepness parseColumnRoot(List<String> list) throws ParseException {
        RootDeepness rootDeepness;
        try {
            rootDeepness = RootDeepness.parseString(list.get(this.rootColumn));
        }
        catch (Exception exception) {
            throw new ParseException(this.rootColumn, exception.toString());
        }
        return rootDeepness;
    }

    NutritionalNeeds parseColumnNutritional(List<String> list) throws ParseException {
        NutritionalNeeds nutritionalNeeds;
        try {
            nutritionalNeeds = new NutritionalNeeds(NutritionalNeeds.Type.valueOf(list.get(this.nutritionalColumn).toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(this.nutritionalColumn, illegalArgumentException.toString());
        }
        return nutritionalNeeds;
    }

    WeedControl parseColumnWeedControl(List<String> list) throws ParseException {
        WeedControl weedControl;
        try {
            weedControl = new WeedControl(WeedControl.Type.valueOf(list.get(this.weedColumn).toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(this.weedColumn, illegalArgumentException.toString());
        }
        return weedControl;
    }

    void parseColumnLifetime() {
    }

    public void importData(StringBuilder stringBuilder) {
        for (int i = 0; i < this.values.size(); ++i) {
            try {
                Object object;
                Object object2;
                List<String> list = this.values.get(i);
                Reference reference = this.parseColumnReference(list);
                Set<Plant> set = this.parseColumnPlant(list, this.nameColumn, this.columns.get(this.nameColumn + 1).compareTo("scientific") == 0);
                if (this.companionColumn != -1) {
                    object2 = this.parseColumnCompanion(list);
                    Iterator<Plant> iterator2 = ((ParsedCompanion)object2).addToCompanions ? ((ParsedCompanion)object2).companions : set;
                    Set<Plant> set2 = !((ParsedCompanion)object2).addToCompanions ? ((ParsedCompanion)object2).companions : set;
                    object = iterator2.iterator();
                    while (object.hasNext()) {
                        Plant plant = (Plant)object.next();
                        for (Plant plant2 : set2) {
                            plant.getCompanions().add(plant2, ((ParsedCompanion)object2).type, ((ParsedCompanion)object2).animals, ((ParsedCompanion)object2).improve, reference);
                        }
                    }
                    if (((ParsedCompanion)object2).eachOther) {
                        for (Plant plant : set2) {
                            Iterator<Plant> iterator = iterator2.iterator();
                            while (iterator.hasNext()) {
                                Plant plant2;
                                plant2 = iterator.next();
                                plant.getCompanions().add(plant2, ((ParsedCompanion)object2).type, ((ParsedCompanion)object2).animals, ((ParsedCompanion)object2).improve, reference);
                            }
                        }
                    }
                }
                if (this.rootColumn != -1) {
                    object2 = this.parseColumnRoot(list);
                    for (Plant plant : set) {
                        object = plant.getRootDeepness();
                        if (object != null && ((RootDeepness)object2).compareTo((RootDeepness)object) != 0) {
                            throw new Exception("Conflict root deepness for " + plant.getTranslation("en") + " ( " + plant.getName() + " ); old value=" + ((RootDeepness)object).toString() + "; new value=" + ((RootDeepness)object2).toString());
                        }
                        plant.setRootDeepness((RootDeepness)object2);
                        plant.getRootDeepness().references.add(reference);
                    }
                }
                if (this.nutritionalColumn != -1) {
                    object2 = this.parseColumnNutritional(list);
                    for (Plant plant : set) {
                        object = plant.getNutritionalNeeds();
                        if (object != null && ((NutritionalNeeds)object2).type.compareTo(((NutritionalNeeds)object).type) != 0) {
                            throw new Exception("Conflict nutritional needs for " + plant.getTranslation("en") + " ( " + plant.getName() + " ); old value=" + ((NutritionalNeeds)object).type.toString() + "; new value=" + ((NutritionalNeeds)object2).type.toString());
                        }
                        plant.setNutritionalNeeds((NutritionalNeeds)object2);
                        plant.getNutritionalNeeds().references.add(reference);
                    }
                }
                if (this.weedColumn == -1) continue;
                object2 = this.parseColumnWeedControl(list);
                for (Plant plant : set) {
                    object = plant.getWeedControl();
                    if (object != null && ((WeedControl)object2).type.compareTo(((WeedControl)object).type) != 0) {
                        throw new Exception("Conflict weed control for " + plant.getTranslation("en") + " ( " + plant.getName() + " ); old value=" + ((WeedControl)object).type.toString() + "; new value=" + ((WeedControl)object2).type.toString());
                    }
                    plant.setWeedControl((WeedControl)object2);
                    plant.getWeedControl().references.add(reference);
                }
                continue;
            }
            catch (Exception exception) {
                stringBuilder.append(exception.getMessage()).append("\n");
            }
        }
    }

    public void setValue(int n, int n2, String string) {
        this.values.get(n).set(n2, string);
        this.checkForErrors(n, n2);
    }

    public DataTableModel getDataTableModel() {
        return this.dataModel;
    }

    public SourceTableModel getSourceTableModel() {
        return this.sourceModel;
    }

    public TagTableModel getTagTableModel() {
        return this.tagModel;
    }

    public TaggedPlantsTableModel getTaggedPlantsTableModel() {
        return this.taggedPlantsModel;
    }

    public void save(File file) {
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.sources.size(); ++i) {
                bufferedWriter.write("source");
                bufferedWriter.write("\t");
                bufferedWriter.write(this.sources.get((int)i).name);
                if (!this.sources.get((int)i).url.isEmpty()) {
                    bufferedWriter.write("\t");
                    bufferedWriter.write(this.sources.get((int)i).url);
                }
                bufferedWriter.newLine();
            }
            for (Map.Entry<String, ArrayList<String>> entry : this.tags.entrySet()) {
                bufferedWriter.write(entry.getKey());
                for (String string : entry.getValue()) {
                    bufferedWriter.write("\t");
                    bufferedWriter.write(string);
                }
                bufferedWriter.newLine();
            }
            for (n = 0; n < this.columns.size(); ++n) {
                if (n != 0) {
                    bufferedWriter.write("\t");
                }
                bufferedWriter.write(this.columns.get(n));
            }
            bufferedWriter.newLine();
            for (n = 0; n < this.values.size(); ++n) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    if (i != 0) {
                        bufferedWriter.write("\t");
                    }
                    bufferedWriter.write(this.values.get(n).get(i));
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class ParsedCompanion {
        public Companion.Type type;
        public Set<Plant> companions;
        public boolean eachOther;
        public boolean addToCompanions;
        public TreeSet<Animal> animals = new TreeSet();
        public TreeSet<Companion.Improve> improve = new TreeSet();

        ParsedCompanion() {
        }
    }

    private class ParseException
    extends Exception {
        int column;
        String message;

        public ParseException(int n, String string) {
            super(string);
            this.column = n;
            this.message = string;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

