/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.io.SpeciesListFormat;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.Lifetime;
import org.sourceforge.kga.plant.NutritionalNeeds;
import org.sourceforge.kga.plant.PropertySource;
import org.sourceforge.kga.plant.Reference;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.plant.RootDeepness;
import org.sourceforge.kga.plant.WeedControl;
import org.sourceforge.kga.wrappers.XmlException;
import org.sourceforge.kga.wrappers.XmlReader;
import org.sourceforge.kga.wrappers.XmlWriter;

class SpeciesListFormatV1
implements SpeciesListFormat {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final int SPECIES_FILE_VERSION = 3;
    public static final String namespace = "org:sourceforge:kga:species";
    int indent = 0;

    SpeciesListFormatV1() {
    }

    private static String serializeIds(Set<Plant> set) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Plant object : set) {
            treeSet.add(object.getId());
        }
        Object object = null;
        for (Integer n : treeSet) {
            if (object == null) {
                object = new StringBuilder();
            }
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(" ");
            }
            ((StringBuilder)object).append(n.toString());
        }
        if (object == null) {
            return null;
        }
        return ((StringBuilder)object).toString();
    }

    private static <E extends Enum<E>> String serializeEnum(E e) {
        return e.name().toLowerCase().replace('_', '-');
    }

    private static <E extends Enum<E>> E deserializeEnum(Class<E> clazz, String string) {
        return Enum.valueOf(clazz, string.toUpperCase().replace('-', '_'));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlantList load(InputStream inputStream) throws IOException, InvalidFormatException {
        PlantList plantList = new PlantList();
        try {
            int n;
            XmlReader xmlReader = new XmlReader(inputStream);
            while (xmlReader.hasNext() && xmlReader.next() != 1) {
            }
            String string = xmlReader.getAttributeValue("", "version");
            if (Integer.parseInt(string) != 3) {
                throw new InvalidFormatException();
            }
            Stack<Object> stack = new Stack<Object>();
            stack.push(Plant.getKingdom());
            Plant plant = new Plant(Taxon.Type.FAMILY, 7200, "Items", Plant.getKingdom());
            plantList.addTaxon(plant);
            int n2 = 0;
            int n3 = 0;
            String string2 = null;
            while (xmlReader.hasNext() && (n = xmlReader.next()) != 8) {
                Object object2;
                if (n == 2) {
                    --n2;
                    if (stack.size() > 1 && xmlReader.getLocalName().compareTo(SpeciesListFormatV1.serializeEnum(((Taxon)stack.lastElement()).getType())) == 0) {
                        object2 = (Taxon)stack.pop();
                        plantList.addTaxon((Taxon)object2);
                        continue;
                    }
                    if (n2 != 0 || string2 == null) continue;
                    string2 = null;
                    continue;
                }
                if (n != 1) continue;
                Object object = xmlReader.getLocalName().equals("family") ? Taxon.Type.FAMILY : (xmlReader.getLocalName().equals("genus") ? Taxon.Type.GENUS : (xmlReader.getLocalName().equals("species") ? Taxon.Type.SPECIES : (object2 = xmlReader.getLocalName().equals("subspecies") ? Taxon.Type.SUBSPECIES : null)));
                if (++n2 >= 1 && object2 != null) {
                    void var13_26;
                    Taxon taxon = (Taxon)stack.lastElement();
                    String string3 = xmlReader.getAttributeValue("", "scientific");
                    if (object2 == Taxon.Type.SPECIES && taxon.getType() == Taxon.Type.GENUS) {
                        String string4 = taxon.getName() + string3.substring(2);
                    }
                    if (object2 == Taxon.Type.SUBSPECIES) {
                        void var13_24;
                        String string5 = taxon.getName().substring(0, taxon.getName().indexOf(32)) + var13_24.substring(2);
                    }
                    int n4 = Integer.parseInt(xmlReader.getAttributeValue("", "id"));
                    Object object3 = null;
                    if (taxon instanceof Plant) {
                        object3 = new Plant((Taxon.Type)((Object)object2), n4, (String)var13_26, (Plant)taxon);
                    } else if (taxon instanceof Animal) {
                        object3 = new Animal((Taxon.Type)((Object)object2), n4, (String)var13_26, (Animal)taxon);
                    }
                    stack.push(object3);
                    String string6 = xmlReader.getAttributeValue("", "name");
                    ((Taxon)object3).setTranslation("en", string6);
                    continue;
                }
                if (stack.size() > 1) {
                    Taxon taxon = (Taxon)stack.lastElement();
                    if (n2 >= 2 && taxon instanceof Plant) {
                        this.loadPlant(plantList, xmlReader, n2, (Plant)taxon);
                        continue;
                    }
                }
                if (n2 == 1 && xmlReader.getLocalName().equals("animals")) {
                    stack.push(Animal.getKingdom());
                    continue;
                }
                if (n2 == 2 && xmlReader.getLocalName().equals("item")) {
                    int n5 = Integer.parseInt(xmlReader.getAttributeValue("", "id"));
                    String string7 = xmlReader.getAttributeValue("", "name");
                    Plant plant2 = new Plant(Taxon.Type.ITEM, n5, string7, plant);
                    plant2.setTranslation("en", string7);
                    plantList.addTaxon(plant2);
                    continue;
                }
                if (n2 == 1 && xmlReader.getLocalName().equals("translation")) {
                    string2 = xmlReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
                    continue;
                }
                if (n2 == 2 && string2 != null && xmlReader.getLocalName().equals("name")) {
                    int n6 = Integer.parseInt(xmlReader.getAttributeValue("", "id"));
                    xmlReader.next();
                    plantList.setTranslation(n6, string2, xmlReader.getText());
                    continue;
                }
                if (n2 == 2 && xmlReader.getLocalName().equals("image")) {
                    int n7 = Integer.parseInt(xmlReader.getAttributeValue("", "id"));
                    Plant plant3 = plantList.getPlant(n7);
                    if (plant3 == null) continue;
                    xmlReader.next();
                    plant3.setImage(xmlReader.getText());
                    continue;
                }
                if (n2 != 2 || !xmlReader.getLocalName().equals("source")) continue;
                int n8 = Integer.parseInt(xmlReader.getAttributeValue("", "id"));
                if (n8 != ++n3) {
                    log.severe("Source id must be increase always by 1");
                }
                plantList.reserveSource(n8);
                PropertySource propertySource = plantList.getSource(n8);
                propertySource.name = xmlReader.getAttributeValue("", "name");
                propertySource.url = xmlReader.getAttributeValue("", "url");
            }
            for (Object object2 : plantList.getPlants()) {
                for (Companion companion : object2.getCompanions().get()) {
                    companion.plant = plantList.getPlant(companion.plant.getId());
                    if (companion.animals.isEmpty()) continue;
                    TreeSet<Animal> treeSet = new TreeSet<Animal>();
                    for (Animal animal : companion.animals) {
                        treeSet.add(plantList.getAnimal(animal.getId()));
                    }
                    companion.animals = treeSet;
                }
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
        log.info("Species list loaded");
        return plantList;
    }

    private void loadPlant(PlantList plantList, XmlReader xmlReader, int n, Plant plant) {
        if (xmlReader.getLocalName().equals("lifetime")) {
            String string = xmlReader.getAttributeValue("", "repetition");
            String string2 = xmlReader.getAttributeValue("", "gap");
            plant.lifetime.set(SpeciesListFormatV1.deserializeEnum(Lifetime.Value.class, xmlReader.getAttributeValue("", "type")), string != null ? Integer.valueOf(Integer.parseInt(string)) : null, string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null);
            this.loadSourceList(xmlReader, plantList, plant.lifetime.references);
        } else if (xmlReader.getLocalName().equals("nutritional-needs")) {
            plant.setNutritionalNeeds(new NutritionalNeeds(SpeciesListFormatV1.deserializeEnum(NutritionalNeeds.Type.class, xmlReader.getAttributeValue("", "value"))));
            this.loadSourceList(xmlReader, plantList, plant.getNutritionalNeeds().references);
        } else if (xmlReader.getLocalName().equals("root")) {
            try {
                plant.setRootDeepness(RootDeepness.parseString(xmlReader.getAttributeValue("", "deepness")));
            }
            catch (Exception exception) {
                log.warning(exception.toString());
            }
            this.loadSourceList(xmlReader, plantList, plant.getRootDeepness().references);
        } else if (xmlReader.getLocalName().equals("weed")) {
            plant.setWeedControl(new WeedControl(SpeciesListFormatV1.deserializeEnum(WeedControl.Type.class, xmlReader.getAttributeValue("", "control"))));
            this.loadSourceList(xmlReader, plantList, plant.getWeedControl().references);
        } else if (xmlReader.getLocalName().equals("companion")) {
            Companion.Type type = SpeciesListFormatV1.deserializeEnum(Companion.Type.class, xmlReader.getAttributeValue("", "type"));
            ReferenceList referenceList = this.loadSourceList(xmlReader, plantList);
            String string = xmlReader.getAttributeValue("", "additional");
            for (String string3 : xmlReader.getAttributeValue("", "id").split(" ")) {
                TreeSet<Animal> treeSet = new TreeSet<Animal>();
                TreeSet<Companion.Improve> treeSet2 = new TreeSet<Companion.Improve>();
                if (type.compareTo(Companion.Type.IMPROVE) == 0) {
                    for (String string4 : string.split(" ")) {
                        treeSet2.add(SpeciesListFormatV1.deserializeEnum(Companion.Improve.class, string4));
                    }
                } else if (type.withAnimals()) {
                    for (String string4 : string.split(" ")) {
                        treeSet.add(new Animal(Integer.parseInt(string4)));
                    }
                }
                plant.getCompanions().add(new Plant(Integer.parseInt(string3)), type, treeSet, treeSet2, referenceList);
            }
        }
    }

    private void loadSourceList(XmlReader xmlReader, PlantList plantList, ReferenceList referenceList) {
        String string = xmlReader.getAttributeValue("", "source");
        if (string == null) {
            return;
        }
        for (String string2 : string.split(" ")) {
            String[] stringArray = string2.split("/");
            PropertySource propertySource = plantList.reserveSource(Integer.parseInt(stringArray[0]));
            referenceList.add(new Reference(propertySource, stringArray.length == 1 ? null : stringArray[1]));
        }
    }

    private ReferenceList loadSourceList(XmlReader xmlReader, PlantList plantList) {
        String string = xmlReader.getAttributeValue("", "source");
        if (string == null) {
            return null;
        }
        ReferenceList referenceList = new ReferenceList();
        for (String string2 : string.split(" ")) {
            String[] stringArray = string2.split("/");
            PropertySource propertySource = plantList.reserveSource(Integer.parseInt(stringArray[0]));
            referenceList.add(new Reference(propertySource, stringArray.length == 1 ? null : stringArray[1]));
        }
        return referenceList;
    }

    void writeStartElement(XmlWriter xmlWriter, String string) throws XmlException {
        xmlWriter.writeCharacters("\n");
        for (int i = 0; i < this.indent; ++i) {
            xmlWriter.writeCharacters("    ");
        }
        ++this.indent;
        xmlWriter.writeStartElement(string);
    }

    void writeEmptyElement(XmlWriter xmlWriter, String string) throws XmlException {
        xmlWriter.writeCharacters("\n");
        for (int i = 0; i < this.indent; ++i) {
            xmlWriter.writeCharacters("    ");
        }
        xmlWriter.writeEmptyElement(string);
    }

    void writeEndElement(XmlWriter xmlWriter) throws XmlException {
        xmlWriter.writeCharacters("\n");
        --this.indent;
        for (int i = 0; i < this.indent; ++i) {
            xmlWriter.writeCharacters("    ");
        }
        xmlWriter.writeEndElement();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(PlantList plantList, DataOutputStream dataOutputStream) throws IOException {
        try {
            void var5_13;
            PropertySource propertySource;
            XmlWriter xmlWriter = new XmlWriter(dataOutputStream, "UTF-8", "1.0");
            this.writeStartElement(xmlWriter, "plants");
            xmlWriter.setDefaultNamespace(namespace);
            xmlWriter.writeDefaultNamespace(namespace);
            xmlWriter.writeAttribute("version", Integer.toString(3));
            for (Plant object2 : plantList.getPlants()) {
                if (object2.getId() == 7200 || object2.getType() != Taxon.Type.FAMILY) continue;
                this.saveTaxon(xmlWriter, object2);
            }
            boolean bl = false;
            for (Plant plant : plantList.getPlants()) {
                if (!plant.isItem()) continue;
                if (!bl) {
                    this.writeStartElement(xmlWriter, "items");
                    bl = true;
                }
                this.writeEmptyElement(xmlWriter, "item");
                xmlWriter.writeAttribute("id", Integer.toString(plant.getId()));
                String string = plant.getTranslation("en");
                if (string == null) continue;
                xmlWriter.writeAttribute("name", string);
            }
            if (bl) {
                this.writeEndElement(xmlWriter);
            }
            this.writeStartElement(xmlWriter, "animals");
            for (Animal animal : plantList.getAnimals()) {
                if (animal.getType() != Taxon.Type.FAMILY) continue;
                this.saveTaxon(xmlWriter, animal);
            }
            this.writeEndElement(xmlWriter);
            for (String string : plantList.getTranslations()) {
                if (string.compareTo("en") == 0) continue;
                this.writeStartElement(xmlWriter, "translation");
                xmlWriter.writeAttribute("xml:lang", string);
                for (int i = 0; i < 2; ++i) {
                    for (Plant plant : plantList.getPlants()) {
                        String string2 = plant.getTranslation(string);
                        if (string2 == null || i == 0 && plant.getType() != Taxon.Type.FAMILY || i != 0 && plant.getType() == Taxon.Type.FAMILY) continue;
                        this.writeStartElement(xmlWriter, "name");
                        xmlWriter.writeAttribute("id", Integer.toString(plant.getId()));
                        xmlWriter.writeCharacters(string2);
                        xmlWriter.writeEndElement();
                        --this.indent;
                    }
                }
                for (Animal animal : plantList.getAnimals()) {
                    String string3 = animal.getTranslation(string);
                    if (string3 == null) continue;
                    this.writeStartElement(xmlWriter, "name");
                    xmlWriter.writeAttribute("id", Integer.toString(animal.getId()));
                    xmlWriter.writeCharacters(string3);
                    xmlWriter.writeEndElement();
                    --this.indent;
                }
                this.writeEndElement(xmlWriter);
            }
            this.writeStartElement(xmlWriter, "images");
            for (Plant plant : plantList.getPlants()) {
                if (plant.getImageAsString() == null) continue;
                this.writeStartElement(xmlWriter, "image");
                xmlWriter.writeAttribute("id", Integer.toString(plant.getId()));
                xmlWriter.writeCharacters(plant.getImageAsString());
                xmlWriter.writeEndElement();
                --this.indent;
            }
            this.writeEndElement(xmlWriter);
            this.writeStartElement(xmlWriter, "resources");
            boolean bl2 = true;
            while ((propertySource = plantList.getSource((int)var5_13)) != null) {
                this.writeEmptyElement(xmlWriter, "source");
                xmlWriter.writeAttribute("id", Integer.toString((int)var5_13));
                xmlWriter.writeAttribute("name", propertySource.name);
                if (propertySource.url != null && !propertySource.url.isEmpty()) {
                    xmlWriter.writeAttribute("url", propertySource.url);
                }
                ++var5_13;
            }
            this.writeEndElement(xmlWriter);
            this.writeEndElement(xmlWriter);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
    }

    private void saveTaxon(XmlWriter xmlWriter, Taxon taxon) throws XmlException {
        Object object;
        boolean bl = taxon.getChildren().isEmpty();
        if (taxon instanceof Plant) {
            object = (Plant)taxon;
            bl &= !((Plant)object).hasNutritionalNeeds() && !((Plant)object).lifetime.isDefined() && !((Plant)object).hasRootDeepness() && !((Plant)object).getCompanions().isDefined();
        }
        if (bl) {
            this.writeEmptyElement(xmlWriter, SpeciesListFormatV1.serializeEnum(taxon.getType()));
        } else {
            this.writeStartElement(xmlWriter, SpeciesListFormatV1.serializeEnum(taxon.getType()));
        }
        xmlWriter.writeAttribute("id", Integer.toString(taxon.getId()));
        object = taxon.getName();
        if (taxon.getType() == Taxon.Type.SPECIES && taxon.getTaxonParent().getType() == Taxon.Type.GENUS || taxon.getType() == Taxon.Type.SUBSPECIES) {
            object = ((String)object).substring(0, 1) + "." + ((String)object).substring(((String)object).indexOf(32));
        }
        xmlWriter.writeAttribute("scientific", (String)object);
        String string = taxon.getTranslation("en");
        if (string != null) {
            xmlWriter.writeAttribute("name", string);
        }
        if (taxon instanceof Plant) {
            this.savePlant(xmlWriter, (Plant)taxon);
        }
        for (Taxon taxon2 : taxon.getChildren()) {
            this.saveTaxon(xmlWriter, taxon2);
        }
        if (!bl) {
            this.writeEndElement(xmlWriter);
        }
    }

    private void savePlant(XmlWriter xmlWriter, Plant plant) throws XmlException {
        if (plant.lifetime.isDefined()) {
            this.writeEmptyElement(xmlWriter, "lifetime");
            xmlWriter.writeAttribute("type", SpeciesListFormatV1.serializeEnum(plant.lifetime.get()));
            if (plant.lifetime.hasRepetitionYears()) {
                xmlWriter.writeAttribute("repetition", Integer.toString(plant.lifetime.getRepetitionYears()));
            }
            if (plant.lifetime.hasRepetitionGap()) {
                xmlWriter.writeAttribute("gap", Integer.toString(plant.lifetime.getRepetitionGap()));
            }
            this.serializeSource(xmlWriter, plant.lifetime.references);
        }
        if (plant.hasNutritionalNeeds()) {
            this.writeEmptyElement(xmlWriter, "nutritional-needs");
            xmlWriter.writeAttribute("value", SpeciesListFormatV1.serializeEnum(plant.getNutritionalNeeds().type));
            this.serializeSource(xmlWriter, plant.getNutritionalNeeds().references);
        }
        if (plant.hasRootDeepness()) {
            this.writeEmptyElement(xmlWriter, "root");
            xmlWriter.writeAttribute("deepness", plant.getRootDeepness().toString());
            this.serializeSource(xmlWriter, plant.getRootDeepness().references);
        }
        if (plant.hasWeedControl()) {
            this.writeEmptyElement(xmlWriter, "weed");
            xmlWriter.writeAttribute("control", SpeciesListFormatV1.serializeEnum(plant.getWeedControl().type));
            this.serializeSource(xmlWriter, plant.getWeedControl().references);
        }
        this.saveCompanions(xmlWriter, plant);
    }

    private void saveCompanions(XmlWriter xmlWriter, Plant plant) throws XmlException {
        ArrayList<Companion> arrayList = new ArrayList<Companion>();
        for (Companion companion : plant.getCompanions().get()) {
            arrayList.add(companion);
        }
        block1: for (Companion.Type type : Companion.Type.values()) {
            while (true) {
                ArrayList<Companion> arrayList2 = new ArrayList<Companion>();
                ReferenceList referenceList = null;
                TreeSet<Object> treeSet = new TreeSet();
                TreeSet<Object> treeSet2 = new TreeSet();
                for (Companion companion : arrayList) {
                    int n;
                    if (companion.type != type) continue;
                    if (arrayList2.isEmpty()) {
                        referenceList = companion.references;
                        treeSet = companion.animals;
                        treeSet2 = companion.improve;
                    }
                    if ((n = companion.references.compareTo(referenceList)) == 0) {
                        if (!companion.animals.equals(treeSet) || !companion.improve.equals(treeSet2)) continue;
                        arrayList2.add(companion);
                        continue;
                    }
                    if (n >= 0) continue;
                    arrayList2.clear();
                    arrayList2.add(companion);
                    referenceList = companion.references;
                    treeSet = companion.animals;
                    treeSet2 = companion.improve;
                }
                if (arrayList2.isEmpty()) continue block1;
                HashSet hashSet = new HashSet();
                for (Companion companion : arrayList2) {
                    arrayList.remove(companion);
                    hashSet.add(companion.plant);
                }
                this.writeEmptyElement(xmlWriter, "companion");
                xmlWriter.writeAttribute("type", SpeciesListFormatV1.serializeEnum(type));
                xmlWriter.writeAttribute("id", SpeciesListFormatV1.serializeIds(hashSet));
                if (!treeSet.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object object : treeSet) {
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(((Taxon)object).getId());
                    }
                    xmlWriter.writeAttribute("additional", stringBuilder.toString());
                }
                if (!treeSet2.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object object : treeSet2) {
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(SpeciesListFormatV1.serializeEnum(object));
                    }
                    xmlWriter.writeAttribute("additional", stringBuilder.toString());
                }
                this.serializeSource(xmlWriter, referenceList);
            }
        }
    }

    private void serializeSource(XmlWriter xmlWriter, Reference reference) throws XmlException {
        if (reference != null) {
            xmlWriter.writeAttribute("source", Integer.toString(reference.source.id));
            if (reference.page != null) {
                xmlWriter.writeAttribute("page", reference.page);
            }
        }
    }

    private void serializeSource(XmlWriter xmlWriter, ReferenceList referenceList) throws XmlException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Reference reference : referenceList) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(reference.source.id);
            if (reference.page == null) continue;
            stringBuilder.append('/');
            stringBuilder.append(reference.page);
        }
        if (stringBuilder.length() != 0) {
            xmlWriter.writeAttribute("source", stringBuilder.toString());
        }
    }
}

