/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.plant;

import org.sourceforge.kga.Plant;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.translation.Translation;

public class Lifetime {
    public static final int DEFAULT_REPETITION_GAP = 3;
    Plant plant;
    Value value;
    Integer repetitionYears = null;
    Integer repetitionGap = null;
    public ReferenceList references = new ReferenceList();

    public Lifetime(Plant plant) {
        this.plant = plant;
    }

    public Value get() {
        if (this.value != null) {
            return this.value;
        }
        if (this.plant.getParent() != null) {
            return this.plant.getParent().lifetime.get();
        }
        return Value.ANNUAL;
    }

    public String translate() {
        Translation translation = Translation.getPreferred();
        switch (this.get()) {
            case ANNUAL: {
                return translation.lifetime_annual();
            }
            case BIENNIAL: {
                return translation.lifetime_biennial();
            }
            case PERENNIAL: {
                return translation.lifetime_perennial();
            }
        }
        return "";
    }

    public int getRepetitionYears() {
        if (this.plant.isItem()) {
            return Integer.MAX_VALUE;
        }
        if (this.value == null) {
            return this.plant.getParent() != null ? this.plant.getParent().lifetime.getRepetitionYears() : 1;
        }
        if (this.value == Value.ANNUAL) {
            return 1;
        }
        if (this.repetitionYears != null) {
            return this.repetitionYears;
        }
        if (this.value == Value.BIENNIAL) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    public int getRepetitionGap() {
        if (this.repetitionGap != null) {
            return this.repetitionGap;
        }
        if (this.plant.getParent() == null) {
            return 3;
        }
        return this.plant.getParent().lifetime.getRepetitionGap();
    }

    public boolean isDefined() {
        return this.value != null;
    }

    public boolean hasRepetitionYears() {
        return this.plant.isItem() || this.value == null || this.value == Value.ANNUAL ? false : this.repetitionYears != null;
    }

    public boolean hasRepetitionGap() {
        return this.repetitionGap != null;
    }

    public void set(Value value, Integer n, Integer n2) {
        this.value = value;
        this.repetitionYears = n;
        this.repetitionGap = n2;
    }

    public static enum Value {
        ANNUAL,
        BIENNIAL,
        PERENNIAL;

    }
}

