/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.plant;

import java.util.HashSet;
import java.util.Set;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.gui.desktop.FileWithChanges;
import org.sourceforge.kga.gui.desktop.SeedFileWithChanges;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.translation.Translation;

public class TagInInventory
extends Tag
implements FileWithChanges.Listener,
SeedList.Listener {
    SeedFileWithChanges seedFile = null;
    SeedList inventory = null;
    SeedList shoppingList = null;
    static TagInInventory instance = new TagInInventory();

    private TagInInventory() {
        super("", null);
    }

    @Override
    public String getName() {
        return Translation.getPreferred().species_in_inventory();
    }

    public void setSeedFile(SeedFileWithChanges seedFileWithChanges) {
        if (this.seedFile != null) {
            this.seedFile.removeListener(this);
        }
        this.seedFile = seedFileWithChanges;
        this.seedFile.addListener(this);
    }

    @Override
    public Set<Plant> getSpecies() {
        HashSet<Plant> hashSet = new HashSet<Plant>();
        if (this.inventory == null) {
            return hashSet;
        }
        for (SeedList seedList : new SeedList[]{this.inventory, this.shoppingList}) {
            for (SeedList.Entry entry : seedList.getFilteredEntries()) {
                if (entry.getPlant().plant == null) continue;
                hashSet.add(entry.getPlant().plant);
            }
        }
        return hashSet;
    }

    public static TagInInventory getInstance() {
        return instance;
    }

    @Override
    public void viewChanged() {
        for (TagListener tagListener : TagList.getInstance().getListeners()) {
            tagListener.tagChanged(this);
        }
    }

    @Override
    public void listChanged() {
        for (TagListener tagListener : TagList.getInstance().getListeners()) {
            tagListener.tagChanged(this);
        }
    }

    @Override
    public void objectChanged() {
        this.inventory = this.seedFile.getSeedInventory();
        this.inventory.addListener(this);
        this.shoppingList = this.seedFile.getSeedShoppingList();
        this.shoppingList.addListener(this);
    }

    @Override
    public void unsavedChangesChanged() {
    }
}

