/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.rules.Rule;

public class Hint {
    private Plant currentPlant;
    private Plant neighborPlant;
    private Point neighborGrid;
    private int neighborYear;
    private Rule rule;
    private Companion companion;
    private Value value;
    private ArrayList<Hint> details = new ArrayList();

    public Hint(Plant plant, Plant plant2, Point point, Rule rule, Companion companion) {
        this.currentPlant = plant;
        this.neighborPlant = plant2;
        this.neighborGrid = point;
        this.neighborYear = 0;
        this.rule = rule;
        this.companion = companion;
        this.value = companion.type.isBeneficial() ? Value.GOOD : Value.BAD;
    }

    public Hint(Plant plant, Plant plant2, int n, Rule rule, Value value) {
        this.currentPlant = plant;
        this.neighborPlant = plant2;
        this.neighborGrid = null;
        this.neighborYear = n;
        this.rule = rule;
        this.companion = null;
        this.value = value;
    }

    public Plant getCurrentPlant() {
        return this.currentPlant;
    }

    public Plant getNeighborPlant() {
        return this.neighborPlant;
    }

    public Point getNeighborGrid() {
        return this.neighborGrid;
    }

    public int getNeighborYear() {
        return this.neighborYear;
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getDescription() {
        return this.rule.getDescription(this);
    }

    public ReferenceList getReferences() {
        return this.rule.getReferences(this);
    }

    public Companion getCompanion() {
        return this.companion;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isRotation() {
        return this.companion == null;
    }

    public void addDetail(Hint hint) {
        this.details.add(hint);
    }

    public ArrayList<Hint> getDetails() {
        return this.details;
    }

    public static enum Value {
        GOOD,
        BAD,
        TIP;

    }
}

