/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.goldang.qaparadigm.Dialog;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.InsetPanel;
import org.goldang.qaparadigm.NumberSpinner;
import org.goldang.qaparadigm.Strings;
import org.goldang.qaparadigm.TextDisplayPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FontDialog
extends Dialog
implements ListSelectionListener,
ChangeListener,
ActionListener {
    private final TextDisplayPanel myTextDisplayPanel;
    private final JList myFontList = new JList();
    private final NumberSpinner mySizeSpinner;

    public FontDialog(FullFrame parent, TextDisplayPanel displayPanel) {
        super((Frame)parent, Strings.res(Strings.FONT));
        this.myTextDisplayPanel = displayPanel;
        this.setContentPane(new InsetPanel(false));
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.myFontList.setSelectionMode(0);
        JScrollPane fontScroller = new JScrollPane();
        fontScroller.setViewportView(this.myFontList);
        int currSize = this.myTextDisplayPanel.getFontSize();
        this.mySizeSpinner = new NumberSpinner(currSize, 1, 600);
        this.mySizeSpinner.setNumberOfColumns(3);
        this.mySizeSpinner.addChangeListener(this);
        JButton okButton = new JButton(Strings.res(Strings.OK));
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(this);
        this.add(fontScroller);
        InsetPanel ipanel = new InsetPanel(false);
        ipanel.setLayout(new BoxLayout(ipanel, 0));
        JButton fitButton = new JButton(Strings.res(Strings.FIT_FONT));
        ipanel.add(new JLabel(Strings.res(Strings.FONT_SIZE)));
        ipanel.add(this.mySizeSpinner);
        ipanel.add(Box.createGlue());
        fitButton.addActionListener(this);
        ipanel.add(fitButton);
        this.add(ipanel);
        ipanel = new InsetPanel(false);
        ipanel.setLayout(new BoxLayout(ipanel, 0));
        ipanel.add(Box.createGlue());
        ipanel.add(okButton);
        this.add(ipanel);
        this.setResizable(true);
        this.center();
        this.pack();
    }

    public void setFontNames(List<String> names) {
        this.myFontList.removeListSelectionListener(this);
        this.myFontList.setListData(names.toArray());
    }

    public void setSelectedFont(String name) {
        this.myFontList.setSelectedValue(name, true);
        this.myFontList.addListSelectionListener(this);
    }

    public String getSelectedFont() {
        return this.myFontList.getSelectedValue().toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.myFontList) {
            this.myTextDisplayPanel.setFontName(this.getSelectedFont());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == Strings.res(Strings.OK)) {
            this.setVisible(false);
        }
        if (e.getActionCommand() == Strings.res(Strings.FIT_FONT)) {
            int size = this.myTextDisplayPanel.sizeFontToFit();
            this.mySizeSpinner.setValue(size);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.mySizeSpinner.commitEdit();
            Integer value = (Integer)this.mySizeSpinner.getValue();
            int size = value;
            this.myTextDisplayPanel.setFontSize(size);
        }
        catch (ParseException pe) {
            this.mySizeSpinner.setValue(this.myTextDisplayPanel.getFontSize());
        }
    }
}

