/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.goldang.qaparadigm.Application;
import org.goldang.qaparadigm.Dialog;
import org.goldang.qaparadigm.InsetPanel;
import org.goldang.qaparadigm.NumberSpinner;
import org.goldang.qaparadigm.Strings;

class PrefsDialog
extends Dialog
implements ActionListener,
ChangeListener {
    private final Preferences thePrefs = Preferences.userNodeForPackage(this.getClass());
    private final JButton myOKButton = new JButton(Strings.res(Strings.OK));
    private final JCheckBox myRandomizeBox = new JCheckBox(Strings.res(Strings.RANDOMIZE), this.thePrefs.getBoolean("Randomize", true));
    private final NumberField myDelayField = new NumberField((double)this.thePrefs.getLong("Delay_MS", 2000L) / 1000.0);
    private final NumberSpinner myDeviceNoSpinner;

    public PrefsDialog(Application app) {
        super((Frame)app, Strings.res(Strings.PREFERENCES));
        this.setContentPane(new InsetPanel(false));
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        InsetPanel ipanel = new InsetPanel(true);
        ipanel.setLayout(new BoxLayout(ipanel, 1));
        this.myRandomizeBox.addActionListener(this);
        this.addUnLabeled(ipanel, this.myRandomizeBox);
        this.myDelayField.addActionListener(this);
        this.addLabeled(ipanel, this.myDelayField, Strings.DELAY_SEC);
        ipanel.add(Box.createGlue());
        this.myDeviceNoSpinner = new NumberSpinner(app.prefDisplayDevice(), 0, app.numDisplayDevices() - 1);
        this.myDeviceNoSpinner.setNumberOfColumns(2);
        this.myDeviceNoSpinner.setEnabled(app.numDisplayDevices() > 1);
        this.myDeviceNoSpinner.addChangeListener(this);
        this.addLabeled(ipanel, this.myDeviceNoSpinner, Strings.DISPLAY_DEV);
        this.add(ipanel);
        this.myOKButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.myOKButton);
        InsetPanel opanel = new InsetPanel(false);
        opanel.setLayout(new BoxLayout(opanel, 0));
        opanel.add(Box.createGlue());
        opanel.add(this.myOKButton);
        this.add(opanel);
        this.setResizable(true);
        this.pack();
        this.center();
        this.setVisible(true);
    }

    private void addLabeled(InsetPanel p, JComponent c, Strings.Key key) {
        InsetPanel ipanel = new InsetPanel(false, 0.0f);
        ipanel.setLayout(new BoxLayout(ipanel, 0));
        ipanel.add(c);
        ipanel.add(new JLabel(Strings.res(key)));
        ipanel.add(Box.createGlue());
        p.add(ipanel);
    }

    private void addUnLabeled(InsetPanel p, JComponent c) {
        InsetPanel ipanel = new InsetPanel(false, 0.0f);
        ipanel.setLayout(new BoxLayout(ipanel, 0));
        ipanel.add(c);
        ipanel.add(Box.createGlue());
        p.add(ipanel);
    }

    public void actionPerformed(ActionEvent e) {
        long ms;
        double val;
        if (e.getSource() == this.myOKButton) {
            val = this.myDelayField.getValue();
            ms = (long)(val * 1000.0);
            this.thePrefs.putLong("Delay_MS", ms);
            this.setVisible(false);
        }
        if (e.getSource() == this.myRandomizeBox) {
            this.thePrefs.putBoolean("Randomize", this.myRandomizeBox.isSelected());
        }
        if (e.getSource() == this.myDelayField) {
            val = this.myDelayField.getValue();
            ms = (long)(val * 1000.0);
            this.thePrefs.putLong("Delay_MS", ms);
        }
    }

    public void stateChanged(ChangeEvent e) {
        try {
            this.myDeviceNoSpinner.commitEdit();
            Integer value = (Integer)this.myDeviceNoSpinner.getValue();
            int size = value;
            this.thePrefs.putInt("DisplayDevice", size);
        }
        catch (ParseException pe) {
            this.myDeviceNoSpinner.setValue(0);
        }
    }

    class DoubleDocument
    extends PlainDocument {
        DoubleDocument() {
        }

        public void replace(int offset, int nchars, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int len = this.getLength();
            String oldtxt = this.getText(0, len);
            super.replace(offset, nchars, str, a);
            len = this.getLength();
            try {
                String txt = this.getText(0, len);
                Double.parseDouble(txt);
            }
            catch (NumberFormatException nfe) {
                super.replace(0, len, oldtxt, a);
            }
        }
    }

    class NumberField
    extends JTextField {
        private static final int NCOLS = 5;

        NumberField(double sec) {
            super(5);
            this.setText(String.valueOf(sec));
            this.setHorizontalAlignment(11);
        }

        public Dimension getMaximumSize() {
            int height = this.getPreferredSize().height;
            int width = super.getPreferredSize().width;
            return new Dimension(width, height);
        }

        protected Document createDefaultModel() {
            return new DoubleDocument();
        }

        double getValue() {
            try {
                String txt = this.getText();
                return Double.parseDouble(txt);
            }
            catch (NumberFormatException nfe) {
                return 2.0;
            }
        }

        public float getAlignmentX() {
            return 0.0f;
        }
    }
}

