//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_DATA_QUEUE
#define FLXBASE_FLX_DATA_QUEUE

#include <string>
#include "flxbase\linkage.h"
#include "flxbase\FlxQueue.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

#define FLX_DATA_LEVELS 9

#define FLX_DATAERROR 0
#define FLX_DATADATA 1
#define FLX_DATAINFO 2
#define FLX_DATAEVENT 3
#define FLX_DATASCRIPT 4
#define FLX_DATAHOOK 5
#define FLX_DATADEBUG 6
#define FLX_DATADDEBUG 7
#define FLX_DATADDDEBUG 8

typedef void (*FlxDataHandler)(int,const string &,const string &);

class FlxDataMessage {
  int d_level;
  long long d_time;
  string d_message;
public:
  FlxDataMessage(int level,long long time,const string &message) : d_level(level), d_time(time), d_message(message) {}
  ~FlxDataMessage() {}
  int level(void){ return d_level; }
  long long time(void){ return d_time; }
  string message(void){ return d_message; }
};

/* DON'T KNOW WHAT THIS LINE WAS SUPPOSED TO DO, BUT IT CAUSED ERRORS ON
   OS X */
//template class FLX_LINKAGE FlxQueue<FlxDataMessage *>;

class FLX_LINKAGE FlxDataQueue {
  FlxQueue<FlxDataMessage *> d_queue;
  string d_filename;
  ofstream *d_stream;
  bool d_file_is_open;
  bool d_file_is_frozen;
  bool d_append_to_existing_file;
  bool d_buffer_messages;
  bool d_do_time_stamp;
  bool d_record_to_file_flags[FLX_DATA_LEVELS];
 public:
  static string level_labels[];
  FlxDataQueue(const string &filename);
  ~FlxDataQueue(void){}
  bool file_is_open(void){ return d_file_is_open; }
  void use_file(const string &filename){ d_filename=filename; }
  string filename(void){ return d_filename; }
  void open_file(void);
  void close_file(void);
  void set_append_to_existing_file(bool append_to_existing_file);
  void set_buffer_messages(bool buffer_messages);
  void set_do_time_stamp(bool do_time_stamp);
  void set_record_to_file_flag(int level,bool flag);
  void freeze(void){ d_file_is_frozen=true; }
  void unfreeze(void){ d_file_is_frozen=false; }
  void write_message(int level,const string &source,const string &message);
  bool flush(void);
};

extern void data_message_to_stderr(int level,const string &message,const string &source);

#endif
