//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_DATA_SYSTEM
#define FLXBASE_FLX_DATA_SYSTEM

#include <string>
#include "flxbase\linkage.h"
#include "flxbase\FlxDataQueue.h"
#include "flxbase\FlxLinkedList.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

class FLX_LINKAGE FlxDataSystem {
  FlxLinkedList<FlxDataQueue *> d_queue_list;
  FlxDataQueue *d_cur_queue;
  bool d_abort_flags[FLX_DATA_LEVELS];
  FlxDataHandler d_handlers[FLX_DATA_LEVELS];
 public:
  FlxDataSystem(void);
  ~FlxDataSystem(void){}
  bool new_queue(const string &filename);
  bool delete_queue(bool force=false);
  void write_message(int level,const string &source,const string &message){ d_cur_queue->write_message(level,source,message); }
  bool file_is_open(void){ return d_cur_queue->file_is_open(); }
  void use_file(const string &filename){ d_cur_queue->use_file(filename); }
  FlxDataQueue *queue(void){ return d_cur_queue; }
  void set_handler(int level,FlxDataHandler handler){ d_handlers[level]=handler; }
  bool abort_flag(int level){ return d_abort_flags[level]; }
  FlxDataHandler handler(int level){ return d_handlers[level]; }
};

FLX_LINKAGE extern FlxDataSystem *flx_data;

#endif
