//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_EVENT
#define FLXBASE_FLX_EVENT

#include <string>
#include <flxbase\FlxObject.h>
#include <flxbase\FlxSetting.h>
#include <flxbase\linkage.h>

/* We need to declare this class here so we can define <flx_cur_event>
   before the definition of <FlxEvent>, because the constructor for
   <FlxEvent> refers to <flx_cur_event> */
class FlxEvent;

FLX_LINKAGE extern FlxEvent *flx_cur_event;

extern long long event_start_time, data_start_time;

/*****************************************************************************/

class FlxEvent : public FlxObject {
 protected:
  bool d_executed;
  bool *d_event_time_reset_point;
  bool *d_data_time_reset_point;
public:
 FlxEvent(const string &name) : FlxObject(name), d_executed(false), d_event_time_reset_point(NULL), d_data_time_reset_point(NULL){
    flx_suspend_setting_updates();
    set_reset_event_time(flx_bool(false));
    set_reset_data_time(flx_bool(false));
    flx_resume_setting_updates();
    flx_change_global_setting(&flx_cur_event,this,"flx_cur_event"); 
  }
  virtual ~FlxEvent(void) {}
  bool operator ==(FlxEvent &e2){ return false; }
  void set_reset_event_time(bool *flag){ flx_change_scalar_setting(this,d_event_time_reset_point,flag,d_name+"::d_event_time_reset_point"); }
  void set_reset_data_time(bool *flag){ flx_change_scalar_setting(this,d_data_time_reset_point,flag,d_name+"::d_data_time_reset_point"); }
  virtual void execute(void){}
  FLX_LINKAGE void do_generic_event_processing(void);
  void mark_as_executed(void){ d_executed=true; }
  bool *get_execution_flag(void){ return &d_executed; }
  virtual void reset(void){ d_executed=false; }
};

/*****************************************************************************/

#endif
