//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_GROUPING_EVENT
#define FLXBASE_FLX_GROUPING_EVENT

#include <string>
#include <flxbase\FlxEvent.h>
#include <flxbase\FlxDuplexList.h>
#include <flxbase\FlxStack.h>
#include <flxbase\FlxCondition.h>

extern bool in_session;
extern FlxStack<long long> event_time_stack, data_time_stack;

/*****************************************************************************/

class GroupingEvent : public FlxEvent {
protected:
  FlxCondition *d_continue_condition;
  FlxDuplexList<FlxEvent *,FlxCondition *> d_sub_event_list;
public:
  GroupingEvent(const string &name,FlxCondition *continue_condition) : FlxEvent(name), d_continue_condition(continue_condition){}
  ~GroupingEvent(void) {}
  void execute(void);
  void flx_add_event(FlxEvent *ep,FlxCondition *cp) { d_sub_event_list.insert(ep,cp); }
};

/*****************************************************************************/

class ExperimentEvent : public GroupingEvent {
public:
  ExperimentEvent(const string &name,FlxCondition *sc) : GroupingEvent(name,sc){}
  ~ExperimentEvent(void) {}
};

/*****************************************************************************/

class BlockEvent : public GroupingEvent {
public:
  BlockEvent(const string &name,FlxCondition *sc) : GroupingEvent(name,sc){}
  ~BlockEvent(void) {}
};

/*****************************************************************************/

class TrialEvent : public GroupingEvent {  
public:
  TrialEvent(const string &name,FlxCondition *sc) : GroupingEvent(name,sc){}
  ~TrialEvent(void) {}
};

/*****************************************************************************/

#endif
