//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_LINKED_LIST
#define FLXBASE_FLX_LINKED_LIST

template <class T> class FlxLinkedListItem; /* This lets the compiler know
		that there is a class FlxLinkedListItem, so the reference to
		it in the definition of FlxLinkedList doesn't produce an
		error. */

template <class T>
class FlxLinkedList {
 protected:
  FlxLinkedListItem<T> *d_list;
  FlxLinkedListItem<T> *d_cur_item;
  FlxLinkedListItem<T> *d_last_item;
  void insert_item(FlxLinkedListItem<T> *);
  void insert_item_sorted(FlxLinkedListItem<T> *);
  void insert_item_at_beginning(FlxLinkedListItem<T> *);
  FlxLinkedListItem<T> *remove_item(void);
 public:
  FlxLinkedList()
    : d_list(NULL), d_cur_item(NULL), d_last_item(NULL) {}
  ~FlxLinkedList() { remove_all(); }
  void insert(T d_item){ insert_item(new FlxLinkedListItem<T>(d_item)); }
  void insert_at_beginning(T d_item){ insert_item_at_beginning(new FlxLinkedListItem<T>(d_item)); }
  void insert_sorted(T d_item){ insert_item_sorted(new FlxLinkedListItem<T>(d_item)); }
  void remove(void){ if(d_cur_item) delete remove_item(); }
  void remove_all(void){ rewind(); while(d_list) remove(); }
  void rewind(void) { d_cur_item=d_list; }
  void advance(void) { if(d_cur_item) d_cur_item=d_cur_item->d_next; }
  T *item(void) { return (d_cur_item) ? &(d_cur_item->d_item) : NULL; }
  T *find_item(const T &expression,bool advance=false);
  T *advance_to_item(const T &expression){ return find_item(expression,true); }
};

template <class T>
class FlxLinkedListItem {
 protected:
  T d_item;
  FlxLinkedListItem<T> *d_next;
 public:
  FlxLinkedListItem(T new_item)
    : d_item(new_item), d_next(NULL) {}
  ~FlxLinkedListItem(void) {}
  friend class FlxLinkedList<T>;
};

template <class T>
void FlxLinkedList<T>::insert_item(FlxLinkedListItem<T> *new_item){

  if(d_last_item==NULL){ // if the list is empty
    d_last_item=d_cur_item=d_list=new_item;
  } else {
	  d_last_item=d_last_item->d_next=new_item;
  }

} /* insert */

template <class T>
void FlxLinkedList<T>::insert_item_at_beginning(FlxLinkedListItem<T> *new_item){
  FlxLinkedListItem<T> *temp;

  if(d_last_item==NULL) d_last_item=d_cur_item=new_item; // if the list is empty
  temp=d_list;
  d_list=new_item;
  d_list->d_next=temp;
  if(d_cur_item==temp) d_cur_item=d_list; /* if the current item pointer
					 was pointing to the beginning
					 of the list, keep it pointing
					 at the beginning of the
					 list */
  
} /* insert_item_at_beginning */

template <class T>
void FlxLinkedList<T>::insert_item_sorted(FlxLinkedListItem<T> *new_item){
  FlxLinkedListItem<T> **temp1, *temp2;
  
  if(d_last_item==NULL){ // if the list is empty
    d_last_item=d_cur_item=d_list=new_item;
  } else {
    temp1=&d_list;
    while(*temp1!=NULL){
		if((*temp1)->d_item>new_item->d_item){
			temp2=(*temp1);
			*temp1=new_item;
			new_item->d_next=temp2;
			return;
	  }
      temp1=&((*temp1)->d_next);
    }
    // we got to the end of the list
    d_last_item=*temp1=new_item;
    new_item->d_next=NULL;
  }

} /* insert_item_sorted */

template <class T>
FlxLinkedListItem<T> *FlxLinkedList<T>::remove_item(void){
  /* Extracts and returns the current item in the d_list. */
  FlxLinkedListItem<T> **index;
  FlxLinkedListItem<T> *old_cur_item;

  if(d_cur_item){
    // get a pointer to the link to the current item
    index=&d_list;
    while(*index!=d_cur_item) index=&((*index)->d_next);
    // remove the current item
    old_cur_item=*index;
	d_cur_item=(*index)=(*index)->d_next;
	old_cur_item->d_next=NULL;
	// update the pointer to the last item, if necessary
	if(d_last_item==old_cur_item){
		if((d_last_item=d_list)) while(d_last_item->d_next) d_last_item=d_last_item->d_next;
	}
    return old_cur_item;
  } else {
    return NULL;
  }

} /* remove_item */

template <class T>
T* FlxLinkedList<T>::find_item(const T &expression,bool advance){
  /* Returns a pointer to the first item in the d_list which
     matches <expression>, starting from <d_cur_item>. If <advance> is
     true, also makes any matching item the current item. */
  FlxLinkedListItem<T> *index;

  index=static_cast<FlxLinkedListItem<T> *>(d_cur_item);
  while(index!=NULL){
    if(index->d_item==expression){
      if(advance) d_cur_item=index;
      return &(index->d_item);
    }
    index=static_cast<FlxLinkedListItem<T> *>(index->d_next);
  }
  return NULL;

} /* find_item */

#endif





