//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_QUEUE
#define FLXBASE_FLX_QUEUE

template <class T> class FlxQueueItem; /* This lets the compiler know
		that there is a class FlxQueueItem, so the reference to
		it in the definition of FlxQueue doesn't produce an
		error. */

template <class T>
class FlxQueue {
 protected:
  FlxQueueItem<T> *d_list;
  FlxQueueItem<T> *d_current;
  FlxQueueItem<T> *d_last;
 public:
  FlxQueue()
    : d_list(NULL), d_current(NULL) {}
  ~FlxQueue() { delete d_list; }
  T remove();
  void advance() { if(d_current) d_current=d_current->d_next; }
  void reset() { d_current=d_list; }
  T *read();
  void insert(T);
};

template <class T>
class FlxQueueItem {
 protected:
  T el;
 public: /* I can't figure out how to make a friend of a child class
	    have access to this member if it's protected */
  FlxQueueItem<T> *d_next;
 public:
  FlxQueueItem(T new_el)
    : el(new_el), d_next(NULL) {}
  ~FlxQueueItem() { if(d_next) delete d_next; }
  friend class FlxQueue<T>;
};

template <class T>
T FlxQueue<T>::remove(){
  // Removes and returns the d_current item in the queue. If the queue
  // is empty, returns the default instance of T; this isn't very
  // helpful, so it's good to check if the queue is empty before
  // calling remove (read is good for this).
  FlxQueueItem<T> *temp, *cur_item;
  T return_val;

  if(d_list){ // queue is non-empty
    if(d_current==d_list){ // d_current item is first in the queue
      temp=d_list->d_next;
      d_list->d_next=NULL;
      return_val=d_list->el;
      delete(d_list);
      d_list=temp;
      d_current=temp;
    } else { // d_current item is not first in the queue
      cur_item=d_list;
      while(cur_item->d_next!=d_current) cur_item=cur_item->d_next;
      temp=cur_item->d_next;
      cur_item->d_next=temp->d_next;
      temp->d_next=NULL;
      return_val=temp->el;
      delete(temp);
      d_current=cur_item;
    }
    return return_val;
  } else 
    return T();

} /* remove */

template <class T>
T *FlxQueue<T>::read(){
  // Return a pointer to the d_current item w/o removing it from queue.
  // Returns NULL if the queue is empty.
  
  if(d_current){
    return &(d_current->el);
 } else
    return NULL;

} /* read */

template <class T>
void FlxQueue<T>::insert(T new_el){
  /* This inserts the item at the end of the queue, just like a FlxLinkedList.
     To avoid traversing the entire queue for each inserting (very inefficient
     for large queues), we keep a pointer <d_last> to the end of the queue */

  if(d_list){
    d_last->d_next=new FlxQueueItem<T>(new_el);
    d_last=d_last->d_next;
  } else {
    d_list=new FlxQueueItem<T>(new_el);
    d_current=d_list;
    d_last=d_list;
  }
  
} /* insert */


#endif






