//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_STACK
#define FLXBASE_FLX_STACK

template <class T> class FlxStackItem; /* This lets the compiler know
		that there is a class FlxStackItem, so the reference to
		it in the definition of FlxStack doesn't produce an
		error. */

template <class T>
class FlxStack {
  FlxStackItem<T> *d_list;
 public:
  FlxStack()
    : d_list(NULL) {}
  ~FlxStack() { delete d_list; }
  T pop();
  T *read();
  void push(T);
};

template <class T>
class FlxStackItem {
  T d_el;
  FlxStackItem<T> *d_next;
 public:
  FlxStackItem(T new_el)
    : d_el(new_el), d_next(NULL) {}
  ~FlxStackItem() { if(d_next) delete d_next; }
  friend class FlxStack<T>;
};

template <class T>
T FlxStack<T>::pop(){
  // Returns the top item from the stack. If the stack is empty, returns
  // the default instance of T; this isn't very hd_elpful, so it's good
  // to check if the stack is empty before calling pop (read is good for this).
  FlxStackItem<T> *temp;
  T return_val;

  if(d_list){
    temp=d_list;
    d_list=d_list->d_next;
    temp->d_next=NULL;
    return_val=temp->d_el;
    delete(temp);
    return return_val;
  } else {
    return T();
  }

} /* pop */

template <class T>
T *FlxStack<T>::read(){
  // Return a pointer to the first item w/o removing it from queue.
  // Returns NULL if the stack is empty.
  
  if(d_list){
    return &(d_list->d_el);
  } else {
    return NULL;
  }

} /* read */

template <class T>
void FlxStack<T>::push(T new_el){
  FlxStackItem<T> *temp;

  temp=new FlxStackItem<T>(new_el);
  temp->d_next=d_list;
  d_list=temp;
  
} /* push */


#endif






