//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_STIMULUS_LIST
#define FLXBASE_STIMULUS_LIST

#include <string>
#include <fstream>
#include "flxbase\linkage.h"
#include "flxbase\FlxObject.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

/*****************************************************************************/

class FlxStimulusList : public FlxObject {
  string **d_items;
  string *d_cur_item;
  long d_num_items;
  long d_num_fields;
  long d_item_index;
  bool d_end_of_list;
public:
  FlxStimulusList(const string &name) : FlxObject(name), d_items(NULL), d_cur_item(NULL), d_num_items(0), d_num_fields(0), d_item_index(0), d_end_of_list(true){}
  ~FlxStimulusList();
  bool read_from_stream(ifstream &);
  bool join_lists(FlxLinkedList<FlxStimulusList *> &the_lists);
  void randomize(void);
  bool update(void);
  long num_items(void){ return d_num_items; }
  long num_fields(void){ return d_num_fields; }
  bool end_of_list(void){ return d_end_of_list; }
  void reset(void){
	  /* only reset the list if it contains some items; otherwise,
		calling this function on an empty list could corrupt
		the data structure */
	  if(d_items){
		d_item_index=-1;
		d_end_of_list=false; 
	} 
  }
  void add_to_update_list(FlxLinkedList<FlxObject *> &update_list);
  string *field_pointer(int);
};

/*****************************************************************************/

extern FlxStimulusList *flx_cur_list;

/*****************************************************************************/

#endif
