//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_FLX_TRIPLEX_LIST
#define FLXBASE_FLX_TRIPLEX_LIST

#include <stdlib.h>
#include "flxbase\FlxDuplexList.h"

template <class T,class T2,class T3> class FlxTriplexListItem; /* This
		lets the compiler know that there is a class
		FlxTriplexListItem, so the reference to it in
		the definition of LabeledList doesn't produce an
		error. */

template <class T,class T2,class T3>
class FlxTriplexList : public FlxDuplexList<T,T2> {
 public:
  FlxTriplexList(void) {}
  ~FlxTriplexList(void) { remove_all(); }
  void insert(T new_item,T2 new_item2,T3 new_item3){ insert_item(new FlxTriplexListItem<T,T2,T3>(new_item,new_item2,new_item3)); }
  void insert_at_beginning(T new_item,T2 new_item2,T3 new_item3){ insert_item_at_beginning(new FlxTriplexListItem<T,T2,T3>(new_item,new_item2,new_item3)); }
  void remove(void){ delete static_cast<FlxTriplexListItem<T,T2,T3> *>(this->remove_item()); }
  void remove_all(void){ this->rewind(); while(this->d_list) remove(); }
  T3 *item3(void) { return (this->d_cur_item) ? &(static_cast<FlxTriplexListItem<T,T2,T3> *>(this->d_cur_item)->d_item3) : NULL; }
  T *find_item3(const T3 &expression,bool advance=false);
  T *advance_to_item3(const T3 &expression){ return find_item3(expression,true); }
};

template <class T,class T2,class T3>
class FlxTriplexListItem : public FlxDuplexListItem<T,T2> {
  T3 d_item3;
 public:
  FlxTriplexListItem(T new_item,T2 new_item2,T3 new_item3)
    : FlxDuplexListItem<T,T2>(new_item,new_item2), d_item3(new_item3) {}
  ~FlxTriplexListItem(void) {}
  friend class FlxTriplexList<T,T2,T3>;
};

template <class T,class T2,class T3>
T* FlxTriplexList<T,T2,T3>::find_item3(const T3 &expression,bool advance){
  /* Returns a pointer to the first item in the list whose attribute
     matches <expression>, starting from <d_cur_item>. If <advance> is
     true, also makes any matching item the current item. */
  FlxTriplexListItem<T,T2,T3> *index;
  
  index=static_cast<FlxTriplexListItem<T,T2,T3> *>(this->d_cur_item);
  while(index!=NULL){
    if(index->d_item3==expression){
      if(advance) this->d_cur_item=index;
      return &(index->d_item);
    }
    index=static_cast<FlxTriplexListItem<T,T2,T3> *>(index->d_next);
  }
  return NULL;

} /* find_item3 */

#endif





