//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_OS_SPECIFIC_MODULES
#define FLXBASE_OS_SPECIFIC_MODULES

#include <string>
#include "flxbase\linkage.h"

using namespace std;

extern int flx_load_module(const string &);
extern void flx_unload_module(const string &);

/* The next two sections do the following:
	1) Provide macros FLX_START_MODULE_INIT and FLX_END_MODULE_INIT for the 
	OS-specific portions of module init functions
	2) Provide a means for including OS-specific module-related headers. For
	this, simply define FLX_INCLUDE_MODULE_HEADER at the beginning of the
	source file, then include this header file (either directly or indirectly
	via <flxbase.h>).
*/

#ifdef FLX_LINUX
#define FLX_START_MODULE_INIT(A) const gchar *g_module_check_init(GModule *gm){
#define FLX_END_MODULE_INIT return NULL; }
#ifdef FLX_INCLUDE_MODULE_HEADER
#include <gmodule.h>
#endif
#endif

#ifdef FLX_WINDOWS
#define FLX_START_MODULE_INIT(A) BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved){ if(fdwReason==DLL_PROCESS_ATTACH){
#define FLX_END_MODULE_INIT } return TRUE; }
#ifdef FLX_INCLUDE_MODULE_HEADER
#ifdef ALLEGRO_H
#include <winalleg.h>
#endif
#include <windows.h>
#endif
#endif

#ifdef FLX_MAC
#define FLX_START_MODULE_INIT(A)  __attribute__ ((constructor)) void A ## _module_init(void) {
#define FLX_END_MODULE_INIT return; }
#ifdef FLX_INCLUDE_MODULE_HEADER

#endif
#endif

#endif
