//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_COMMAND_MANAGER
#define FLXBASE_COMMAND_MANAGER

#include <string>
#include "flxbase\FlxCommand.h"
#include "flxbase\linkage.h"

/*****************************************************************************/

/* overloaded versions of a function to add commands with various numbers of
   arguments */

/* these first two aren't template functions, so they're defined in
   command_manager.ccp rather than here */
FLX_LINKAGE bool flx_do_add_command(const string &,FlxCommand *);

// This is for no-argument commands
FLX_LINKAGE bool flx_add_command(const string &,bool (*)(void));

template <class A> 
bool flx_add_command(const string &name,bool (*f)(A *),const string &optional_argument="NOOPT"){
  return flx_do_add_command(name,new FlxOneArgCommand<A>(f,optional_argument));
}

FLX_LINKAGE extern void reorder_opt_args(string *opt_args,int args_required);

/* FOR THE FOLLOWING THREE FUNCTIONS: If only some optional argument
     values are provided, then the order in which they are passed to
     these functions will not be the correct order for passing them to
     the command function. Thus, we reorder them as appropriate
     here using the <reorder_args> function. */

template <class A,class B> 
bool flx_add_command(const string &name,bool (*f)(A *,B *),const string &optional_argument1="NOOPT",const string &optional_argument2="NOOPT"){
  string opt_args[]={optional_argument1,optional_argument2};

  reorder_opt_args(opt_args,2);
  return flx_do_add_command(name,new FlxTwoArgCommand<A,B>(f,opt_args[0],opt_args[1]));
}

template <class A,class B,class C> 
bool flx_add_command(const string &name,bool (*f)(A *,B *,C *),const string &optional_argument1="NOOPT",const string &optional_argument2="NOOPT",const string &optional_argument3="NOOPT"){
  string opt_args[]={optional_argument1,optional_argument2,optional_argument3};
  
  reorder_opt_args(opt_args,3);
  return flx_do_add_command(name,new FlxThreeArgCommand<A,B,C>(f,opt_args[0],opt_args[1],opt_args[2]));
}

template <class A,class B,class C,class D> 
bool flx_add_command(const string &name,bool (*f)(A *,B *,C *,D *),const string &optional_argument1="NOOPT",const string &optional_argument2="NOOPT",const string &optional_argument3="NOOPT",const string &optional_argument4="NOOPT"){
  string opt_args[]={optional_argument1,optional_argument2,optional_argument3,optional_argument4};

  reorder_opt_args(opt_args,4);
  return flx_do_add_command(name,new FlxFourArgCommand<A,B,C,D>(f,opt_args[0],opt_args[1],opt_args[2],opt_args[3]));
}

FLX_LINKAGE extern bool flx_execute_command(const string &,int,string *);

#endif
