//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_STRING_UTILS
#define FLXBASE_STRING_UTILS

#include <limits.h>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <ctype.h>
#include <string>
#include "flxbase\linkage.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

// string_utils.cc
FLX_LINKAGE int flx_string_compare_ignore_case(const string &,const string &);
FLX_LINKAGE bool flx_string_to_bool(const string &,bool *err_flag=NULL);
FLX_LINKAGE int flx_string_to_int(const string &,bool *err_flag=NULL);
FLX_LINKAGE long flx_string_to_long(const string &,bool *err_flag=NULL);
FLX_LINKAGE long long flx_string_to_long_long(const string &,bool *err_flag=NULL);
FLX_LINKAGE float flx_string_to_float(const string &,bool *err_flag=NULL);
FLX_LINKAGE double flx_string_to_double(const string &,bool *err_flag=NULL);
FLX_LINKAGE string flx_string_strip_parens(const string &);
FLX_LINKAGE string flx_string_strip_quotes(const string &);
FLX_LINKAGE string flx_string_strip_white(const string &);

template <class T>
string flx_convert_to_string(const T &val){
  ostringstream temp;

  temp << val;
  return temp.str();
  
} /* flx_convert_to_string */

#endif







