//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXBASE_TIME
#define FLXBASE_TIME

#include <string>
#include "flxbase\OS_specific_time.h"
#include "flxbase\linkage.h"

/* We need this so we don't have to qualify all STL names with
"std::" */
using namespace std;

FLX_LINKAGE extern bool flx_microseconds_enabled;
FLX_LINKAGE extern bool flx_using_microseconds;

extern string flx_get_date(void);
FLX_LINKAGE extern void flx_delay(long);
extern void flx_init_timer(void);
extern void flx_exit_timer(void);

#define flx_get_time() (flx_using_microseconds ? flx_get_microseconds() : flx_get_milliseconds())

#endif
