//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxbase\FlxCommand.h"

/*****************************************************************************/

FLX_LINKAGE void apply_opt_args(int &argc,string *argv,string *opt_args,int args_required){
  string cur_function="apply_opt_args";
  int i;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Applying optional arguments: "+flx_convert_to_string(argc)+" arguments provided, "+flx_convert_to_string(args_required)+" arguments required");
  i=args_required-1;
  while(argc<args_required){
    if(opt_args[i]!="NOOPT"){
      flx_data->write_message(FLX_DATADEBUG,cur_function,"Argument not provided, using default value'"+opt_args[i]+"'");
      argv[i]=opt_args[i];
      i--;
      argc++;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Argument not provided, and there is no default value");
      break;
    }
  }

} /* apply_opt_args */

/*****************************************************************************/

// This isn't a template functions, so it can't go in commands.h

bool FlxNoArgCommand::execute_command(int argc,string *argv){
  string cur_function="execute_command";

  if(argc!=0){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+flx_cur_script_command+" doesn't take any arguments");
    return false;
  } else {
    return d_function_ptr();
  }
}

/*****************************************************************************/



