//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxbase\FlxDataSystem.h"

FlxLinkedList<FlxDataQueue *> data_queue_list;

FlxDataSystem data_system;
FLX_LINKAGE FlxDataSystem *flx_data=&data_system;

/*****************************************************************************/

FlxDataSystem::FlxDataSystem(void){

  d_abort_flags[FLX_DATAERROR]=true;
  d_abort_flags[FLX_DATADATA]=false;
  d_abort_flags[FLX_DATAINFO]=false;
  d_abort_flags[FLX_DATAEVENT]=false;
  d_abort_flags[FLX_DATASCRIPT]=false;
  d_abort_flags[FLX_DATAHOOK]=false;
  d_abort_flags[FLX_DATADEBUG]=false;
  d_abort_flags[FLX_DATADDEBUG]=false;
  d_abort_flags[FLX_DATADDDEBUG]=false;
  
  d_handlers[FLX_DATAERROR]=data_message_to_stderr;
  d_handlers[FLX_DATADATA]=NULL;
  d_handlers[FLX_DATAINFO]=NULL;
  d_handlers[FLX_DATAEVENT]=NULL;
  d_handlers[FLX_DATASCRIPT]=NULL;
  d_handlers[FLX_DATAHOOK]=NULL;
  d_handlers[FLX_DATADEBUG]=NULL;
  d_handlers[FLX_DATADDEBUG]=NULL;
  d_handlers[FLX_DATADDDEBUG]=NULL;

} /* FlxDataSystem::FlxDataSystem */

/*****************************************************************************/

bool FlxDataSystem::new_queue(const string &filename){
  string cur_function="FlxDataSystem::new_queue";
  string expanded_filename;
  FlxDataQueue **next_queue;
  bool found_name;
  
  /* check if there is already a queue with this name */
  found_name=false;
  while((next_queue=d_queue_list.item())){
    if((*next_queue)->filename()==filename){
      found_name=true;
      break;
    }
    d_queue_list.advance();
  }
  d_queue_list.rewind();

  if(found_name){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Can't create new data queue, there is already a queue named "+filename);
    return false;
  } else {
    d_cur_queue=new FlxDataQueue(filename);
    d_queue_list.insert_at_beginning(d_cur_queue);
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Creating new data queue named "+filename);
    return true;
  }

} /* FlxDataSystem::new_queue */

/*****************************************************************************/

bool FlxDataSystem::delete_queue(bool force){
  string cur_function="FlxDataSystem::delete_queue";
  FlxDataQueue **next_queue;

  /* Check if there is another queue that we can revert back to. If
   there is, delete the current queue, and send new data messages to
   that queue. If there's not, we keep the current queue, unless <force>
   is true. */
  d_queue_list.advance();
  next_queue=d_queue_list.item();
  d_queue_list.rewind();
  if(next_queue || force){
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Deleting data queue "+d_cur_queue->filename());
    if(next_queue){
      flx_data->write_message(FLX_DATADEBUG,cur_function,"Reverting to queue "+(*next_queue)->filename());
    }
    /* close the data file */
    d_cur_queue->close_file();
    d_queue_list.remove();
    delete d_cur_queue;
    if(next_queue){
      d_cur_queue=*next_queue;
    }
    return true;
  } else {
    flx_data->write_message(FLX_DATADEBUG,cur_function,"Can't delete data queue "+d_cur_queue->filename()+" because it is the only remaining queue");
    return false;
  }
      
} /* FlxDataSystem::delete_queue */

/*****************************************************************************/
