//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include "flxbase\FlxDuplexList.h"
#include "flxbase\modules.h"
#include "flxbase\file_system.h"
#include "flxbase\OS_specific_file_system.h"
#include "flxbase\scopes.h"

#ifdef FLX_LINUX
#include <gmodule.h>
#endif
#ifdef FLX_WINDOWS
#include <windows.h>
#endif
#ifdef FLX_MAC
#include <mach-o\dyld.h>
#endif

using namespace std;

#ifdef FLX_LINUX
FlxDuplexList<GModule *,string> module_pointer_list;
string module_prefix="libflx";
string module_suffix=".so";
#endif
#ifdef FLX_WINDOWS
FlxDuplexList<HMODULE,string> module_pointer_list;
string module_prefix="flx";
string module_suffix=".dll";
#endif
#ifdef FLX_MAC
class FlxMacModule {
public:
  NSObjectFileImage d_image;
  NSModule d_module;
  FlxMacModule(void){}
  ~FlxMacModule(void){}
};
FlxDuplexList<FlxMacModule *,string> module_pointer_list;
string module_prefix="libflx";
string module_suffix=".dylib";
#endif

/*****************************************************************************/

int flx_load_module(const string &module_name){
  string cur_function="flx_load_module";
#ifdef FLX_LINUX
  GModule *mp;
#endif
#ifdef FLX_WINDOWS
  HMODULE mp;
#endif
#ifdef FLX_MAC
  FlxMacModule *mp;
#endif
  string module_file;
  
  module_file=flx_expand_filename(module_prefix+module_name+module_suffix);
  if(module_file.empty()){    
    return FLX_MODFILENOTFOUND;
  } else {
    flx_begin_scope(module_name);
#ifdef FLX_LINUX
    if((mp=g_module_open(module_file.c_str(),GModuleFlags(0)))){
#endif
#ifdef FLX_WINDOWS
      if((mp=LoadLibrary(module_file.c_str()))){
#endif
#ifdef FLX_MAC
	mp=new FlxMacModule();
       	if(NSCreateObjectFileImageFromFile(module_file.c_str(),&(mp->d_image))==NSObjectFileImageSuccess){
      	  mp->d_module=NSLinkModule(mp->d_image,module_file.c_str(),NSLINKMODULE_OPTION_NONE);
#endif
	module_pointer_list.insert(mp,module_name);
       	flx_end_scope();
	return FLX_MODOK;
      } else {
	flx_delete_scope(module_name);
	return FLX_MODLOADERROR;
      }
  }

} /* flx_load_module */

/*****************************************************************************/

void flx_unload_module(const string &name){
  string cur_function="flx_unload_module";
#ifdef FLX_LINUX
  GModule **mp;
#endif
#ifdef FLX_WINDOWS
  HMODULE *mp;
#endif
#ifdef FLX_MAC
  FlxMacModule **mp;
#endif
  if((mp=module_pointer_list.advance_to_item2(name))){
#ifdef FLX_LINUX
	  g_module_close(*mp);
#endif
#ifdef FLX_WINDOWS
	FreeLibrary(*mp);
#endif
#ifdef FLX_MAC
	//NSUnLinkModule((*mp)->d_module,NSUNLINKMODULE_OPTION_NONE);
	//NSDestroyObjectFileImage((*mp)->d_image);
#endif
    module_pointer_list.remove();
    module_pointer_list.rewind();
  }

} /* flx_unload_module */

/*****************************************************************************/

