//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <sstream>
#include "flxbase\FlxDataSystem.h"
#include "flxbase\scripts.h"
#include "flxbase\FlxTriplexList.h"
#include "flxbase\event_manager.h"
#include "flxbase\event_hooks.h"
#include "flxbase\command_manager.h"
#include "flxbase\strings.h"
#include "flxbase\logical_and_numeric_types.h"
#include "flxbase\string_utils.h"
#include "flxbase\condition_manager.h"
#include "flxbase\object_manager.h"
#include "flxbase\scopes.h"
#include "flxbase\linkage.h"

FlxTriplexList<FlxConditionParser,string,string> condition_type_list;

string flx_default_condition_text;

/*****************************************************************************/

void remove_condition_types_by_scope(const string &tag){
  string cur_function="remove_condition_types_by_scope";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing condition types with scope '"+tag+"'");
  while(condition_type_list.advance_to_item3(tag)){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Removing condition type '"+*(condition_type_list.item2())+"'");
    condition_type_list.remove();
  }
  condition_type_list.rewind();

} /* remove_condition_types_by_scope */

/*****************************************************************************/

class WaitEvent : public FlxEvent {
  FlxCondition *d_wait_condition;
public:
  WaitEvent(const string &name,FlxCondition *wait_condition) : FlxEvent(name), d_wait_condition(wait_condition){}
  ~WaitEvent(void) {}
  void execute(void);
  void reset(void){ d_wait_condition->reset(); FlxEvent::reset(); }
};

void WaitEvent::execute(void){
  string cur_function="WaitEvent::execute";
  
  this->do_generic_event_processing();

  while(d_wait_condition->evaluate()){
    flx_execute_event_hooks(FLX_EVENT_HOOK_WITHINEVENT); 
    if(flx_force_exit) return;
  }
  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
}

/*****************************************************************************/

bool NewWaitEvent(string *name,FlxCondition *cp){
  string cur_function="NewWaitEvent";
  WaitEvent *wep;
  
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new WaitEvent '"+*name+"'");
  wep=new WaitEvent(*name,cp);
  flx_add_object_source(wep,cp);
  return true;

} /* NewWaitEvent */

/*****************************************************************************/

FLX_LINKAGE bool flx_type_convert(const string &s,FlxCondition *&cp){
  string cur_function="flx_type_convert";
  string clean_s;
  //FlxCondition *old_cp;
  istringstream *line_stream;
  string keyword, next_arg;
  FlxLinkedList<string> arg_list;
  string *arg_array;
  int arg_count=0, i;
  FlxConditionParser *parser_ptr=NULL;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converting '"+s+"' to a condition");
  /* We don't implement condition variables for now; it also causes
    problems with having a variable name rather than a keyword as the
    first item in the condition */
  /*  if(s.size() && s[0]=='$'){ // we have a variable name
    clean_s=s.substr(1); // strip off the leading $
    old_cp=cp;
    cp=flx_get_object_by_name<FlxCondition>(clean_s);
    if(cp){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a variable");
      return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"There is no condition variable named '"+clean_s+"'");
      cp=old_cp;
      return false;
    }
  } else { // we have a literal value
  */
    /* This is hack to provide a way for the default trigger condition
       for AddEvent to be determined at the time the command is executed,
       rather than at the time the command is added. It could be used for
       other purposes as well, though. */
    if(s=="default_condition"){
      clean_s=flx_default_condition_text;
    } else {
      clean_s=s;
    }
    /* Parse into a keyword and arguments. Keyword need not be the first word,
       as long as no previous word is also a keyword */
    line_stream=new istringstream(clean_s.c_str());
    while(*line_stream >> keyword && !line_stream->fail()){
      // check if we've got a keyword
      if((parser_ptr=condition_type_list.find_item2(keyword))){
	break;
      } else {
	arg_list.insert(keyword);
	arg_count++;
      }
    }
    
    if(!parser_ptr){
      flx_data->write_message(FLX_DATAERROR,cur_function,"Can't find any condition keyword in condition '"+s+"'");
      cp=NULL;
      return false;
    } else { // extract any remaining arguments
      while(*line_stream >> next_arg && !line_stream->fail()){
	arg_list.insert(next_arg);
	arg_count++;
      }
    }
    delete line_stream;
    
    /* copy the arguments into a string array */
    arg_array=new string[arg_count];
    for(i=0;i<arg_count;i++){
      arg_array[i]=*(arg_list.item());
      arg_list.advance();
    }
    
    /* now we pass the arguments to the appropriate parser function, which
       returns the actual FlxCondition object */
    cp=(*parser_ptr)(keyword,arg_count,arg_array);
    delete [] arg_array;
    if(cp){
      flx_data->write_message(FLX_DATADEBUG,cur_function,"Successfully converted "+keyword+" condition");
      return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Can't convert "+keyword+" condition '"+s+"'");
      return false;
    }

} /* flx_type_convert */

/*****************************************************************************/

FLX_LINKAGE void flx_add_condition_type(const string &keyword,FlxConditionParser cp){
  string cur_function="flx_add_condition_type";

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Adding condition type '"+keyword+"'");
  condition_type_list.insert(cp,keyword,flx_cur_scope_tag);

} /* flx_add_condition_type */

/*****************************************************************************/

void flx_condition_manager_init(void){

  flx_add_command("WaitEvent",NewWaitEvent);
  flx_add_scope_cleanup_hook("remove_condition_types_by_scope",remove_condition_types_by_scope);
  flx_default_condition_text="repeat";

} /* flx_condition_manager_init */

/*****************************************************************************/
