//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxbase\FlxDataSystem.h"
#include "flxbase\strings.h"
#include "flxbase\logical_and_numeric_types.h"
#include "flxbase\command_manager.h"
#include "flxbase\scripts.h"
#include "flxbase\time.h"
#include "flxbase\object_manager.h"
#include "flxbase\event_manager.h"

/****************************************************************************/

bool WriteData(string *msg){
  string cur_function="WriteData";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Writing message '"+*msg+"' to the data file");
  flx_data->write_message(FLX_DATADATA,cur_function,*msg);
  return true;

} /* WriteData */

/*****************************************************************************/

class DataEvent : public FlxEvent {
  FlxLinkedList<FlxObject *> d_columns;
public:
  DataEvent(const string &name) : FlxEvent(name) {}
  ~DataEvent(void) {}
  void add_column(FlxObject *column){ d_columns.insert(column); }
  void execute(void);
};

void DataEvent::execute(void){
  string cur_function="DataEvent::execute";
  string message_string;
  FlxObject **column;

  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
  this->do_generic_event_processing();

  message_string="";
  while((column=d_columns.item())){
    /* insert a tab between fields */
    if(message_string!="") message_string+="\t";
    message_string+=(*column)->value_as_string();
    d_columns.advance();
  } 
  d_columns.rewind();
  flx_data->write_message(FLX_DATADATA,cur_function,message_string);
}

/*****************************************************************************/

bool NewDataEvent(string *name){
  string cur_function="NewDataEvent";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DataEvent '"+*name+"'");
  new DataEvent(*name);
  return true;

} /* NewDataEvent */

/*****************************************************************************/

bool DataColumn(FlxLiteralString *col){
  string cur_function="DataColumn";
  DataEvent *dep;
  string var_name;
  FlxObject *fop;

  // first, check the current event to make sure it can have columns
  if((dep=dynamic_cast<DataEvent *>(flx_cur_event))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Adding data column to '"+dep->name()+"'");
    /* Two types of columns to handle here: variables and literal
       strings. If <col> begins with '$', we
       treat it as a variable, otherwise as a literal string. */
    if((*col).size() && (*col)[0]=='$'){ // we have a variable name
      var_name=(*col).substr(1); // strip off the leading $
      if(!(fop=flx_get_object_by_name<FlxObject>(var_name))){
	flx_data->write_message(FLX_DATAERROR,cur_function,"No variable named "+var_name+", can't add data column");
	return false;
      }
    } else { // we have a literal string
      fop=new FlxScalarObject<string>(flx_unique_name());
      dynamic_cast<FlxScalarObject<string> *>(fop)->set_value(*col);
    }
    dep->add_column(fop);
    flx_add_scalar_source(dep,col);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_event).name())+" can't have data columns");
    return false;
  }
  
} /* DataColumn */

/*****************************************************************************/

void flx_data_events_init(void){

  flx_create_scalar_object("time",&flx_data_time);
  flx_add_command("WriteData",WriteData);
  flx_add_command("DataEvent",NewDataEvent);
  flx_add_command("DataColumn",DataColumn);

} /* flx_data_events_init */

/*****************************************************************************/

