//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxbase\flxbase.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\time.h"
#include "flxbase\file_system.h"
#include "flxbase\OS_specific_file_system.h"
#include "flxbase\scopes.h"
#include "flxbase\scripts.h"
#include "flxbase\FlxStack.h"
#include "flxbase\FlxLinkedList.h"

extern void flx_scopes_init(void);
extern void flx_data_manager_init(void);
extern void flx_time_init(void);
extern void flx_condition_manager_init(void);
extern void flx_basic_conditions_init(void);
extern void flx_object_manager_init(void);
extern void flx_command_manager_init(void);
extern void flx_event_hooks_init(void);
extern void flx_event_manager_init(void);
extern void flx_list_manager_init(void);
extern void flx_scripts_init(void);
extern void flx_strings_init(void);
extern void flx_logical_and_numeric_types_init(void);
extern void flx_random_init(void);
extern void flx_data_events_init(void);
extern void flx_macros_init(void);
extern void flx_file_system_init(void);
extern void flx_modules_init(void);

FLX_LINKAGE string flxlab_dir="";
FLX_LINKAGE string flx_default_script_file="<none selected>";
FLX_LINKAGE string flx_script_file="";
FLX_LINKAGE bool abort_flxlab; 
ProgramHook program_hook;
FlxStack<ProgramHook> program_hook_stack;

/*****************************************************************************/

FLX_LINKAGE void flx_set_program_hook(ProgramHook f){

  program_hook_stack.push(program_hook);
  program_hook=f;

} /* set_program_hook */

/*****************************************************************************/

FLX_LINKAGE void flx_revert_program_hook(void){

  program_hook=program_hook_stack.pop();

} /* revert_program_hook */

/*****************************************************************************/

int flxlab(void){
  string cur_function="flxlab";
  FlxLinkedList<string> config_files;
  string *config_file;
  bool return_val;

  return_val=false;
  abort_flxlab=false;
  flx_init_timer();
  flx_data->new_queue(flxlab_dir+"log.txt");
  flx_data->queue()->set_record_to_file_flag(FLX_DATAINFO,true);
  flx_data->queue()->set_append_to_existing_file(true);
  flx_data->queue()->set_buffer_messages(false);
  flx_data->write_message(FLX_DATAINFO,cur_function,"FLXLab starting at "+flx_get_date());
  flx_scopes_init();
  flx_data_manager_init();
  flx_time_init();
  flx_condition_manager_init();
  flx_basic_conditions_init();
  flx_object_manager_init();
  flx_command_manager_init();
  flx_event_hooks_init();
  flx_event_manager_init();
  flx_list_manager_init();
  flx_scripts_init();
  flx_strings_init();
  flx_logical_and_numeric_types_init();
  flx_random_init();
  flx_data_events_init();
  flx_macros_init();
  flx_modules_init();
  flx_file_system_init();
  
  /* the default behavior after configuration is complete is to just
     execute the specified script; this can be changed by setting
     <program_hook> to point to another function */
  program_hook=flx_read_script;

  if(!abort_flxlab){ /* check if there were any fatal errors in the
  			base initialization */
    flx_get_directory_entries(flxlab_dir+"config",config_files,FLX_FS_FILES);
    while((config_file=config_files.item())){
	/* we only read files in the config directory if they have an extension
	   of .flx; this prevents the program from trying to read Emacs
	   auto-save files (ending in ~) or log files that ended up in the
	   config directory */
	if(flx_extract_extension(*config_file)=="flx"){
	    flx_data->write_message(FLX_DATAINFO,cur_function,"Reading configuration file '"+flx_extract_filename(*config_file)+"'");
	    flx_read_script_file(flxlab_dir+"config"+flx_path_separator+*config_file,true,false);
	    if(abort_flxlab){ /* check if there were any fatal errors
				 during this config file */
		break;
	    }
	}
	config_files.advance();
    }
    config_files.rewind();
    
    if(!abort_flxlab){ 
      return_val=program_hook();
    }
  }  
  flx_delete_scope("BASE");
  flx_data->write_message(FLX_DATAINFO,cur_function,"FLXLab exiting at "+flx_get_date());
  flx_data->write_message(FLX_DATAINFO,cur_function,"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
  flx_data->delete_queue(true);
  flx_exit_timer();  
  // return 0 for success, 1 for failure
  return (return_val ? 0 : 1);

} /* flxlab */

/*****************************************************************************/

