//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include <sstream>
#include <iomanip>
#include "flxbase\strings.h"
#include "flxbase\FlxDuplexList.h"
#include "flxbase\FlxDataSystem.h"
#include "flxbase\scripts.h"
#include "flxbase\command_manager.h"
#include "flxbase\event_hooks.h"
#include "flxbase\object_manager.h"
#include "flxbase\string_utils.h"
#include "flxbase\time.h"

using namespace std;

/*****************************************************************************/

FLX_LINKAGE string *flx_string(string s){

  return flx_X(s);
}

/*****************************************************************************/

FLX_LINKAGE bool flx_type_convert(const string &s,string *&sp){
  string cur_function="flx_type_convert";
  string clean_s, *old_sp;
  FlxScalarObject<string> *sop;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converting '"+s+"' to a string");
  
  if(s.size() && s[0]=='$'){ // we have a variable name
    clean_s=s.substr(1); // strip off the leading $
    old_sp=sp;
    sop=flx_get_object_by_name<FlxScalarObject<string> >(clean_s);
    if(sop){
      sp=sop->value();
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a variable");
      return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"There is no string variable named '"+clean_s+"'");
      sp=old_sp;
      return false;
    }
  } else { // we have a string literal
    if(sp){
      *sp=s;
    } else {
      sp=flx_string(s);
    }
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converted as a literal value");
    return true;
  }
}

/*****************************************************************************/

/* This is for when you either don't need or don't want variables to be
   expanded */
FLX_LINKAGE bool flx_type_convert(const string &s,FlxLiteralString *&sp){
  string cur_function="flx_type_convert";
  
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Converting '"+s+"' to a literal string (no variable expansion)");
  if(sp){
    *sp=FlxLiteralString(s);
  } else {
    sp=flx_X(FlxLiteralString(s));
  }
  return true;
}

/*****************************************************************************/

class JoinedString : public FlxScalarObject<string> {
  FlxLinkedList<string *> d_substrings;
  string *d_separator;
public:
  JoinedString(const string &name,string *separator) : FlxScalarObject<string>(name), d_separator(separator){ d_value=new string(); }
  ~JoinedString(void) { delete d_value; }
  void add(string *s) { d_substrings.insert(s); }
  bool update(void);
};

bool JoinedString::update(void){
  string cur_function="JoinedString::update";
  string **str_handle;
  bool is_first;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Updated joined string");
  *d_value="";
  is_first=true;
  while((str_handle=d_substrings.item())){
    if(is_first){
      is_first=false;
    } else {
      *d_value+=*d_separator;
    }
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Added string "+**str_handle);
    *d_value+=**str_handle;
    d_substrings.advance();
  }
  d_substrings.rewind();
  return true;
}

/*****************************************************************************/

bool JoinStrings(string *name,FlxLiteralString *s,string *separator){
  string cur_function="JoinStrings";
  JoinedString *js;
  istringstream strings_to_join(s->c_str());
  string next_string;
  string *string_ptr;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new joined string with label '"+*name+"'");
  js=new JoinedString(*name,separator);
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Created the JoinedString object");
  flx_add_scalar_source(js,separator);
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Added separator as source");
  /* parse <s> into individual words, apply variable expansion to each
     word, and add the resulting strings to the list of strings to
     be joined together */
  while(strings_to_join >> next_string && !strings_to_join.fail()){
    string_ptr=NULL;
    flx_type_convert(next_string,string_ptr);
    js->add(string_ptr);
    flx_add_scalar_source(js,string_ptr);
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Added a string as source");
  }
  flx_process_dependencies(js);
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Processed dependencies");
  return true;

} /* JoinStrings */

/*****************************************************************************/

void flx_strings_init(void){

  flx_add_command("JoinStrings",JoinStrings,"");

} /* flx_strings_init */

/*****************************************************************************/

