## FLXLab v2.3 - A program for running psychology experiments.  
## Copyright (C) 2009 Todd R. Haskell (todd.haskell@wwu.edu) 
## 
## Use and distribution is governed by the terms of the 
## GNU General Public License. Certain portions of the 
## program may be subject to other licenses as well. See 
## the file LICENSE.TXT for details.
## 
#!/usr/bin/perl

# THIS CONVERTS TEXT FILES FROM THE FORMAT FOR ONE OPERATING SYSTEM TO THE
# FORMAT USED BY ANOTHER OPERATING SYSTEM. THIS CHIEFLY INVOLVES CHANGING
# THE END-OF-LINE CHARACTER, THOUGH IT ALSO TRIES TO FIX PATH NAMES IN
# #include STATEMENTS. IT ALSO MODIFIES Makefile.system TO SET THE OS TYPE
# WE ARE BUILDING FOR.

use Cwd;
use File::Glob ':case';

$OSTYPE=$ARGV[0];

if($OSTYPE eq "windows"){
    $eol="\015\012";
} elsif($OSTYPE eq "linux" || $OSTYPE eq "mac"){
    $eol="\012";
} elsif($OSTYPE eq "oldmac"){
    $eol="\015";
} else {
    die "Unknown OS type $OSTYPE!\n";
}

@COMPONENTS=(".","allegro","jpgalleg","glyphkeeper","agup","base","mod_graphics","mod_text","mod_gui","mod_sounddriver","mod_sound","mod_startscreen");
$BASEDIR=&Cwd::cwd();

foreach $COMPONENT (@COMPONENTS) {
    print STDERR "* $COMPONENT\n";
    $OLDDIR=&Cwd::cwd();
    chdir $COMPONENT;
    foreach $FILE (glob("Makefile* *.TXT *.txt *.flx *_demo/*.flx *_demo/*.txt src/*.cpp src/*.c include/*.h include/flx*/*.h *.sh")){
	print STDERR "  > $FILE\n";
	@LINES=read_file($FILE);
	for($i=0;$i<=$#LINES;$i++){
	    if($OSTYPE eq "windows"){
		$LINES[$i]=~s/#include (.+)\/(.+)\//#include \1\\\2\\/g;
		$LINES[$i]=~s/#include (.+)\//#include \1\\/g;
	    } elsif($OSTYPE eq "linux" || $OSTYPE eq "mac"){
		$LINES[$i]=~s/#include (.+)\\(.+)\\/#include \1\/\2\//g; 
		$LINES[$i]=~s/#include (.+)\\/#include \1\//g;
	    } 
	}
	write_file($FILE,@LINES);
    }
    chdir $OLDDIR;
}

# NOW SET THE OS TYPE IN Makefile.system
print STDERR "*** Setting OS type to $OSTYPE ***";
@LINES=read_file("Makefile.system");
for($i=0;$i<=$#LINES;$i++){
    if($LINES[$i]=~/FLXLABOS=/){
	$LINES[$i]="FLXLABOS=$OSTYPE";
    }
}
write_file("Makefile.system",@LINES);

#------------------------------------------------------------------------------
# THIS READS THE FILE WHOSE NAME IS SPECIFIED ON AN ARGUMENT, AND
# RETURNS A LIST WHOSE ELEMENTS ARE THE LINES IN THAT FILE, REGARDLESS
# OF THE EOL MARKER USED IN THAT FILE
sub read_file {
    my @lines;
    my $curline;
    my $firsteolchar;
    my $char;
    my $filename;

    $filename=$_[0];
    open(MYFILE,$filename) or die "Can't open file for reading!";
    binmode(MYFILE);
    @lines=();
    $curline="";
    $firsteolchar="false";
    while(read(MYFILE,$char,1)){
	# These lines filter out end-of-line characters regardless of
	# the file format. We assume we've reached the end of a line
	# when we encounter either a CR or a LF; the variable
	# $firsteol is used to help us identify a CR/LF combination
	# and distinguish it from two EOL's in a row. The $filetype
	# variable is just for diagnostic purposes, and it indicates
	# the script's guess about the file type we are converting
	# from.
	if($char eq "\012"){
	    if($firsteolchar eq "false"){
		push(@lines,$curline);
		$curline="";
		$filetype="unix";
	    } else {
		$filetype="dos";
	    }
	    $firsteolchar eq "false";
	} elsif($char eq "\015"){
	    push(@lines,$curline);
	    $curline="";
	    $firsteolchar="true";
	    $filetype="mac";
	} else {
	    $curline=$curline.$char;
	    $firsteolchar="false";
	}
    }
    close(MYFILE);
    return @lines;
}

#------------------------------------------------------------------------------

sub write_file {
    my $filename;
    my $i;

    $filename=$_[0];
    open(MYFILE,">$filename") or die "Can't open file for writing!";
    binmode(MYFILE);
    for($i=1;$i<=$#_;$i++){
	print MYFILE "$_[$i]$eol";
    }
    close(MYFILE);
}

#------------------------------------------------------------------------------
