//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_GRAPHICS_OBJECTS
#define FLXGRAPHICS_GRAPHICS_OBJECTS

#include <string>
#include <allegro.h>
#include <flxbase.h>
#include <linkflx.h>
#include "flxgraphics\colors.h"
#include "flxgraphics\positions.h"

FLX_LINKAGE extern FlxColor *flx_default_color;
FLX_LINKAGE extern long *flx_default_line_width;
FLX_LINKAGE extern FlxLength *flx_default_x_size;
FLX_LINKAGE extern FlxLength *flx_default_y_size;
FLX_LINKAGE extern bool *flx_default_filled;

/* We need to declare this class here so we can define
   <flx_cur_graphics_object> before the definition of
   <FlxGrahpicsObject>, because the constructor for
   <FlxGraphicsObject> refers to <flx_cur_graphics_object> */
class FlxGraphicsObject;

FLX_LINKAGE extern FlxGraphicsObject *flx_cur_graphics_object;

/*****************************************************************************/

class FLX_LINKAGE FlxGraphicsObject : public FlxObject {
public:
 FlxGraphicsObject(const string &name) : FlxObject(name) { flx_change_global_setting(&flx_cur_graphics_object,this,"flx_cur_graphics_object"); }
  virtual ~FlxGraphicsObject() {}
  virtual int x_size(void){ return 0; }
  virtual int y_size(void){ return 0; }
  virtual void draw(void) {}
};

/*****************************************************************************/
/* THE CLASSES BELOW ARE INTENDED AS BUILDING BLOCKS; THEY CAN BE COMBINED
   WITH EACH OTHER AND FLXGRAPHICSOBJECT TO CREATE MORE COMPLEX GRAPHICS
   OBJECTS */
/*****************************************************************************/

class FLX_LINKAGE FlxColoredObject : virtual public FlxGraphicsObject {
 protected:
  FlxColor *d_color;
 public:
 FlxColoredObject(void) : FlxGraphicsObject(""), d_color(NULL) { this->set_color(flx_default_color); }
  ~FlxColoredObject() {}
  FlxColor *color(void){ return d_color; }
  void set_color(FlxColor *color) { flx_change_object_setting(this,d_color,color,"FlxColoredObject::d_color"); }
};

/*****************************************************************************/

class FLX_LINKAGE FlxLinedObject : virtual public FlxGraphicsObject {
 protected:
  long *d_line_width;
 public:
 FlxLinedObject(void) : FlxGraphicsObject(""), d_line_width(NULL) { this->set_line_width(flx_default_line_width); }
  ~FlxLinedObject() {}
  long *line_width(void) { return d_line_width; }
  void set_line_width(long *line_width) { flx_change_scalar_setting(this,d_line_width,line_width,"FlxLinedObject::d_line_width"); }
};

/*****************************************************************************/

class FLX_LINKAGE FlxSizedObject : virtual public FlxGraphicsObject {
 protected:
  FlxLength *d_x_size;
  FlxLength *d_y_size;
 public:
 FlxSizedObject(void) : FlxGraphicsObject(""), d_x_size(NULL), d_y_size(NULL) { this->set_x_size(flx_default_x_size); this->set_y_size(flx_default_y_size); }
  ~FlxSizedObject() {}
  /* FlxGraphicsObject already has functions for reading the size of
     an object, so we only provide functions for setting the size
     here. Since we use multiple inheritance to build more complex
     graphics objects, if we implemented size-reading functions here,
     it would mean two sets of functions (and thus ambiguity) when
     combining FlxGraphicsObject and FlxSizedObject.  So, it's up to
     each derived class to override the default size-reading
     functions from FlxGraphicsObject. */
  void set_x_size(FlxLength *x_size){ flx_change_object_setting(this,d_x_size,x_size,"FlxSizedObject::d_x_size"); } 
  void set_y_size(FlxLength *y_size){ flx_change_object_setting(this,d_y_size,y_size,"FlxSizedObject::d_y_size"); } 
};

/*****************************************************************************/

class FLX_LINKAGE FlxFilledObject : virtual public FlxGraphicsObject {
 protected:
  bool *d_filled;
 public:
 FlxFilledObject(void) : FlxGraphicsObject(""), d_filled(NULL) { this->set_filled(flx_default_filled); }
  ~FlxFilledObject() {}
  bool *filled(void){ return d_filled; }
  void set_filled(bool *filled) { flx_change_scalar_setting(this,d_filled,filled,"FlxFilledObject::d_filled"); }
};

/*****************************************************************************/

FLX_LINKAGE extern FlxGraphicsObject *flx_cur_graphics_object;
extern FlxStack<FlxGraphicsObject *>flx_reference_graphics_object_stack;

FLX_LINKAGE extern bool flx_type_convert(const string &,FlxGraphicsObject *&);

#endif
