//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGRAPHICS_SCREEN
#define FLXGRAPHICS_SCREEN

#include "flxgraphics\shape_objects.h"
#include <linkflx.h>

class FlxScreenObject : public FlxColoredObject, public FlxSizedObject {
  int d_graphics_mode;
  long *d_refresh_rate;
  int d_color_depth;
  bool d_is_initialized;
 public:
 FlxScreenObject(const string &name) : FlxGraphicsObject(name), d_refresh_rate(NULL), d_is_initialized(false) { 
    flx_suspend_setting_updates();
    this->set_x_size(flx_length(0,FLX_LENGTH_ABSOLUTE));
    this->set_y_size(flx_length(0,FLX_LENGTH_ABSOLUTE));
    this->set_color(flx_color(255,255,255));
    flx_resume_setting_updates();
  } 
  ~FlxScreenObject() {}
  void set_refresh_rate(long *refresh_rate){ flx_change_scalar_setting(this,d_refresh_rate,refresh_rate,"FlxScreenObject::d_refresh_rate"); }
  FLX_LINKAGE void reset(void);
  FLX_LINKAGE bool initialize(void);
  FLX_LINKAGE bool display(void);
  FLX_LINKAGE bool minimize(void);
  /* we need these size functions because they are not provided by
   FlxSizedObject; see the class declaration for an explanation */
  int x_size(void) { return d_x_size->value(FLX_LENGTH_X); }
  int y_size(void) { return d_y_size->value(FLX_LENGTH_Y); }
  void draw(void){ clear_to_color(screen,d_color->color_code()); }
};

FLX_LINKAGE extern FlxScreenObject *flx_screen;

#endif
