//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include "flxgraphics\colors.h"
#include <flxbase.h>
#include <linkflx.h>

FLX_LINKAGE FlxColor *flx_transparent_color;

/*****************************************************************************/

bool FlxColor::update(void){
  string cur_function="FlxColor::update";
  FlxColor *cp=NULL;
  
  if(d_source_string){
    if(flx_do_object_convert(*d_source_string,cp,"FlxColor")){
      flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Updating FlxColor by converting from string '"+*d_source_string+"'");
      d_red=cp->d_red;
      d_green=cp->d_green;
      d_blue=cp->d_blue;
      return true;
    } else {
      return false;
    }
  } else {
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Nothing to update");
    return true;
  }

} /* FlxColor::update */

/*****************************************************************************/

FLX_LINKAGE FlxColor *flx_color(long r,long g,long b){
  string cur_function="flx_color";
  FlxColor *cop;
  string name;

  name="FlxColor:"+flx_unique_name();
  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating object of type FlxColor named '"+name+"'");
  cop=new FlxColor(name);
  flx_suspend_setting_updates();
  cop->set_red(flx_long(r));
  cop->set_green(flx_long(g));
  cop->set_blue(flx_long(b));
  flx_resume_setting_updates();
  return cop;
  
} /* flx_color */

/*****************************************************************************/

FLX_LINKAGE bool flx_type_convert(const string &s,FlxColor *&cp){

  return flx_object_convert_with_implicit<FlxColor>(s,cp,"FlxColor");
}

/*****************************************************************************/

bool DefineColor(string *label,long *r,long *g,long *b){
  string cur_function="DefineColor";
  FlxColor *new_color;

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Defining color '"+*label+"'");
  new_color=new FlxColor(*label);
  flx_suspend_setting_updates();
  new_color->set_red(r);
  new_color->set_green(g);
  new_color->set_blue(b);
  flx_resume_setting_updates();
  return true;

} /* DefineColor */

/*****************************************************************************/

void flx_colors_init(void){

  flx_transparent_color=new FlxColor("transparent");

  flx_add_command("DefineColor",DefineColor);

} /* flx_colors_init */
  
/*****************************************************************************/
