//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//
#define FLX_INCLUDE_MODULE_HEADER
#include <string>
#include <allegro.h>
#include <jpgalleg.h>
#include <flxbase.h>

#include "flxgraphics\screen.h"

extern void flx_colors_init(void);
extern void flx_positions_init(void);
extern void flx_graphics_objects_init(void);
extern void flx_line_objects_init(void);
extern void flx_shape_objects_init(void);
extern void flx_image_objects_init(void);
extern void flx_object_boxes_init(void);
extern void flx_graphics_events_init(void);
extern void flx_screen_init(void);

/*****************************************************************************/

/* In Windows, if we try to manipulate the screen while the module is
still loading, the program crashes. To work around this, we define
this function that gets called immediately after the module has
finished loading. */

void graphics_init_callback(void){
	string cur_function="graphics_init_callback";

	allegro_init();
	jpgalleg_init();
	flx_screen->reset();
	if(!(flx_screen->initialize())){
	  flx_data->write_message(FLX_DATAERROR,cur_function,"Couldn't initialize screen, aborting");
	}
	flx_reference_graphics_object_stack.push(flx_screen);

} /* graphics_init_callback */

/*****************************************************************************/

void graphics_exit(void){

  allegro_exit();
  flx_reference_graphics_object_stack.pop();

} /* graphics_exit */

/*****************************************************************************/

extern "C" {

  FLX_START_MODULE_INIT(graphics)

  string cur_function="graphics_module_init";

  flx_data->write_message(FLX_DATAINFO,cur_function,"Initializing graphics module");
  flx_colors_init();
  flx_positions_init();
  flx_graphics_objects_init();
  flx_line_objects_init();
  flx_shape_objects_init();
  flx_image_objects_init();
  flx_object_boxes_init();
  flx_graphics_events_init();
  flx_screen_init();
  flx_cur_graphics_object=NULL;
  flx_add_scope_exit_hook("graphics_exit",graphics_exit);
  flx_set_module_post_load_callback(graphics_init_callback);

  FLX_END_MODULE_INIT

}

/*****************************************************************************/




