//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include <allegro.h>
#include "flxgraphics\graphics_objects.h"
#include "flxgraphics\screen.h"
#include "flxgraphics\graphics_events.h"
#include <linkflx.h>

FLX_LINKAGE BITMAP *flx_cur_buffer;
bool *flx_default_wait_for_refresh;

/*****************************************************************************/

bool FlxDisplayEvent::update(void){
  string cur_function="DisplayEvent::update";

  if(d_object_box && d_position && d_alignment){
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Updating display bitmap for '"+d_name+"'");
    if(d_display_buffer) destroy_bitmap(d_display_buffer);
    d_display_buffer=create_bitmap(d_object_box->x_size(),d_object_box->y_size()); 
    // figure out where on the screen we'll copy the buffer to
    flx_pen->move(-1*d_position->x(),-1*d_position->y());
    flx_reference_graphics_object_stack.push(d_object_box);
    flx_pen->move(d_alignment->x(),d_alignment->y());
    flx_reference_graphics_object_stack.pop();
    flx_cur_buffer_offset_x=d_buffer_offset_x=-1*flx_pen->x();
    flx_cur_buffer_offset_y=d_buffer_offset_y=-1*flx_pen->y();
    flx_pen->undo_move();
    flx_pen->undo_move();
    // actually draw the objects
    flx_cur_buffer=d_display_buffer;
    d_object_box->draw();
  } else {
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Display event '"+d_name+"' is not fully defined, skipping update");
  }
  return true;
}

void FlxDisplayEvent::execute(void){
   string cur_function="DisplayEvent::execute";

   flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
   this->do_generic_event_processing();

   // we make sure we have a buffer before trying to copy it
   if(d_display_buffer){
     if(*d_wait_for_refresh) vsync();
     acquire_screen();
     masked_blit(d_display_buffer,screen,0,0,d_buffer_offset_x,d_buffer_offset_y,d_object_box->x_size(),d_object_box->y_size());
     release_screen();
   } else {
     flx_data->write_message(FLX_DATAERROR,cur_function,"Attempt to execute display event without a valid display buffer");
   }
}

/*****************************************************************************/

bool NewDisplayEvent(string *name,FlxPosition *position,FlxPosition *alignment){
  string cur_function="NewDisplayEvent";
  FlxDisplayEvent *dp;
  
  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DisplayEvent '"+*name+"'");
  dp=new FlxDisplayEvent(*name,position,alignment);
  return true;

} /* NewDisplayEvent */

/*****************************************************************************/

bool SetWaitForRefresh(bool *flag){
  string cur_function="SetWaitForRefresh";
  FlxDisplayEvent *dep;

  if(flx_cur_event==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default wait-for-refresh attribute");
    flx_change_global_setting(&flx_default_wait_for_refresh,flag,"flx_default_wait_for_refresh");
    return true;
  } else if((dep=dynamic_cast<FlxDisplayEvent *>(flx_cur_event))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting wait-for-refresh attribute of '"+dep->name()+"'");
    dep->set_wait_for_refresh(flag);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": "+string(typeid(*flx_cur_event).name())+" doesn't have a wait-for-refresh attribute");
    return false;
  }

} /* SetWaitForRefresh */

/*****************************************************************************/

void flx_graphics_events_init(void){

  flx_add_command("DisplayEvent",NewDisplayEvent,"center","center");
  flx_add_command("WaitForRefresh",SetWaitForRefresh,"true");
  flx_default_wait_for_refresh=flx_bool(false);
  flx_create_scalar_object("default_wait_for_refresh",flx_default_wait_for_refresh);

} /* flx_graphics_events_init */
  
/*****************************************************************************/
