//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <string>
#include <allegro.h>
#include "flxgraphics\object_boxes.h"
#include <linkflx.h>

/*****************************************************************************/

void FlxGraphicsObjectBox::draw(){
  string cur_function="FlxGraphicsObjectBox::draw";
  FlxGraphicsObjectArrayElement *element_ptr;

  flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Drawing "+flx_convert_to_string(x_size())+"x"+flx_convert_to_string(y_size())+" object box '"+d_name+"' at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
  FlxRectangleObject::draw();
  flx_reference_graphics_object_stack.push(this);
  while((element_ptr=d_object_list.item())){
    flx_pen->move(element_ptr->position()->x(),element_ptr->position()->y());
    /* we always do alignment relative to the object being aligned */
    flx_reference_graphics_object_stack.push(element_ptr->object());
    flx_pen->move(-1*element_ptr->alignment()->x(),-1*element_ptr->alignment()->y());
    flx_reference_graphics_object_stack.pop();
    element_ptr->object()->draw();
    flx_pen->undo_move();
    flx_pen->undo_move();
    d_object_list.advance();
  }
  d_object_list.rewind();
  flx_reference_graphics_object_stack.pop();
  
}

/*****************************************************************************/

bool NewObjectBox(string *name){
  string cur_function="NewObjectBox";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new ObjectBox '"+*name+"'");
  new FlxGraphicsObjectBox(*name);
  return true;

} /* NewObjectBox */

/*****************************************************************************/

bool AddObject(FlxGraphicsObject *op,FlxPosition *position,FlxPosition *alignment){
  string cur_function="AddObject";
  FlxGraphicsObjectBox *obp;
  
  if((obp=dynamic_cast<FlxGraphicsObjectBox *>(flx_cur_graphics_object))){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Adding object '"+op->name()+"' to '"+obp->name()+"'");
    obp->add_object(op,position,alignment);
    flx_add_object_source(obp,op);
    flx_add_object_source(obp,position);
    flx_add_object_source(obp,alignment);
    flx_process_dependencies(obp);
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Can't add graphics objects to a "+string(typeid(*flx_cur_graphics_object).name()));
    return false;
  }
  
} /* AddObject */
 
/*****************************************************************************/

void flx_object_boxes_init(void){

  flx_add_command("ObjectBox",NewObjectBox);
  flx_add_command("AddObject",AddObject,"center","center");

} /* flx_object_boxes_init */
  
/*****************************************************************************/
