//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxgraphics\shape_objects.h"
#include "flxgraphics\graphics_events.h"
#include <flxbase.h>
#include <linkflx.h>

/*****************************************************************************/

void FlxRectangleObject::draw(void){
  int i;

  flx_data->write_message(FLX_DATADDDEBUG,"FlxRectangleObject::draw","Drawing "+flx_convert_to_string(x_size())+"x"+flx_convert_to_string(y_size())+" rectangle '"+d_name+"' at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
  if(*d_filled){
    rectfill(flx_cur_buffer,flx_pen->x(),flx_pen->y(),flx_pen->x()+x_size(),flx_pen->y()+y_size(),d_color->color_code());
  } else {
    for(i=0;i<*d_line_width;i++){
      rect(flx_cur_buffer,flx_pen->x()+i,flx_pen->y()+i,flx_pen->x()+x_size()-i,flx_pen->y()+y_size()-i,d_color->color_code());
    }
  }
}

/*****************************************************************************/

bool NewRectangleObject(string *name){
  string cur_function="NewRectangleObject";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new FlxRectangleObject '"+*name+"'");
  new FlxRectangleObject(*name);
  return true;

} /* NewRectangleObject */

/*****************************************************************************/

void FlxEllipseObject::draw(void){
  int i;
  int x_radius, y_radius;

  flx_data->write_message(FLX_DATADDDEBUG,"FlxEllipseObject::draw","Drawing "+flx_convert_to_string(x_size())+"x"+flx_convert_to_string(y_size())+" ellipse '"+d_name+"' at ("+flx_convert_to_string(flx_pen->screen_x())+","+flx_convert_to_string(flx_pen->screen_y())+")");
  x_radius=x_size()/2;
  y_radius=y_size()/2;
  if(*d_filled){
    ellipsefill(flx_cur_buffer,flx_pen->x()+x_radius,flx_pen->y()+y_radius,x_radius,y_radius,d_color->color_code());
  } else {
    for(i=0;i<*d_line_width;i++){
      ellipse(flx_cur_buffer,flx_pen->x()+x_radius,flx_pen->y()+y_radius,x_radius-i,y_radius-i,d_color->color_code());
    }
  }
}

/*****************************************************************************/

bool NewEllipseObject(string *name){
  string cur_function="NewEllipseObject";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new FlxEllipseObject '"+*name+"'");
  new FlxEllipseObject(*name);
  return true;

} /* NewEllipseObject */

/*****************************************************************************/

void flx_shape_objects_init(void){

  flx_add_command("RectangleObject",NewRectangleObject);
  flx_add_command("EllipseObject",NewEllipseObject);

} /* flx_shape_objects_init */

/*****************************************************************************/
