//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_BITMAPS
#define FLXGUI_DIALOG_BITMAPS

#include "flxgui\dialog_objects.h"

/*****************************************************************************/

class FLX_LINKAGE FlxDialogBitmap : public FlxDialogObject {
 protected:
  string *d_bitmap_file;
  void *d_bitmap;
 public:
 FlxDialogBitmap(const string &name) : FlxDialogObject(name), d_bitmap(NULL) {}
  ~FlxDialogBitmap(void){ if(d_bitmap) destroy_bitmap(static_cast<BITMAP *>(d_bitmap)); }
  void set_bitmap_file(string *bitmap_file){ d_bitmap_file=bitmap_file; }
  int num_elements(void){ return 1; }
  FLX_LINKAGE bool update(void);
  FLX_LINKAGE void build(void *d,int &max_object_width,int &cur_y);
};

/*****************************************************************************/

#endif
