//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_BUTTONS
#define FLXGUI_DIALOG_BUTTONS

#include "flxgui\dialog_objects.h"

#define FLX_DIALOG_BUTTON 1
#define FLX_DIALOG_RADIO 2

/*****************************************************************************/

class FLX_LINKAGE FlxDialogButtonGroup : public FlxDialogObject {
protected:
	int d_type;
	int d_group;
	FlxLinkedList<string *> d_button_list;
 public:
 FlxDialogButtonGroup(const string &name) : FlxDialogObject(name) {}
  ~FlxDialogButtonGroup() {}
  void set_type(int type){ d_type=type; }
  void set_group_id(int group){ d_group=group; }
  FLX_LINKAGE int num_elements(void);
  void add_button(string *text){ d_button_list.insert(text); }
  FLX_LINKAGE void build(void *d,int &max_object_width,int &cur_y);
  int offer_focus(void){ return (this->num_elements()>0 ? 0 : -1); } 
  FLX_LINKAGE string exit_object(void);
  FLX_LINKAGE void update_value(int return_status);
};

/*****************************************************************************/

#endif
