//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXGUI_DIALOG_LISTS
#define FLXGUI_DIALOG_LISTS

#include "flxgui\dialog_objects.h"

FLX_LINKAGE extern bool *flx_close_on_click_true;
FLX_LINKAGE extern bool *flx_close_on_click_false;

/*****************************************************************************/

class FLX_LINKAGE FlxDialogList : public FlxDialogObject {
protected:
	int d_list_id;
	FlxLinkedList<string *> d_item_list;
	bool *d_close_on_click;
 public:
 FlxDialogList(const string &name) : FlxDialogObject(name), d_close_on_click(NULL) { this->set_close_on_click(flx_close_on_click_false); }
  FLX_LINKAGE ~FlxDialogList();
  void set_list_id(int list_id){ d_list_id=list_id; }
 int num_elements(void){ return 1; }
  void add_item(string *text){ d_item_list.insert(text); }
  void remove_items(void){ d_item_list.remove_all(); }
  void set_close_on_click(bool *close_on_click){ flx_change_scalar_setting(this,d_close_on_click,close_on_click,"FlxDialogList::d_close_on_click"); }
  FLX_LINKAGE void build(void *d,int &max_object_width,int &cur_y);
  int offer_focus(void){ return 0; }
  FLX_LINKAGE void update_value(int return_status);
};

/*****************************************************************************/

#endif
