//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>

FONT *original_font;
DATAFILE *bitmap_font_data;
int flx_gui_font_height, flx_gui_font_width;

/*****************************************************************************/

void bitmap_fonts_exit(void){
  string cur_function="bitmap_fonts_exit";

  flx_data->write_message(FLX_DATADDEBUG,cur_function,"Unloading bitmap font data");
  unload_datafile(bitmap_font_data);
  font=original_font;

} /* bitmap_fonts_exit */

/*****************************************************************************/

void flx_bitmap_fonts_init(void){
  string cur_function="flx_bitmap_fonts_init";
  int i=0;
  string font_name;
  bool gui_font_set;
 
  // store a pointer to the basic allegro font
  original_font=font;

  // load other fonts from the font data file
  if(!(bitmap_font_data=load_datafile((flxlab_dir+"resources"+flx_path_separator+"bitmap_fonts.dat").c_str()))){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Couldn't open bitmap font data file");
  } else {
    flx_data->write_message(FLX_DATADDEBUG,cur_function,"Loading bitmap fonts");
    gui_font_set=false;
    while(bitmap_font_data[i].type!=DAT_END){
      if(bitmap_font_data[i].type==DAT_FONT){
	// we use the first font in the file as the GUI font
	if(!gui_font_set){
	  font=static_cast<FONT *>(bitmap_font_data[i].dat);
	  gui_font_set=true;
	  break;
	}
      }
      i++;
    }
  }

  /* These are useful for sizing graphics objects in terms of numbers of
	characters */
  flx_gui_font_height=text_height(font);
  flx_gui_font_width=text_length(font,"G");

  flx_add_scope_exit_hook("bitmap_fonts_exit",bitmap_fonts_exit);

} /* flx_bitmap_fonts_init */

/*****************************************************************************/


