//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//

#include <allegro.h>
#include <flxbase.h>
#include <agup.h>
#include "flxgui\dialog_objects.h"
#include "flxgui\dialog_events.h"
#include "flxgui\bitmap_fonts.h"

#include "flxgui\dialog_alerts.h"

/*****************************************************************************/

FLX_LINKAGE FlxDialogEvent::~FlxDialogEvent(void){

	if(d_dialog_array) delete static_cast<DIALOG *>(d_dialog_array);
	if(d_dialog_owners) delete d_dialog_owners;
	
} /* FlxDialogEvent::~FlxDialogEvent */

/*****************************************************************************/

FLX_LINKAGE bool FlxDialogEvent::update(void){
	string cur_function="FlxDialogEvent::update";
	DIALOG *dialog;
	FlxDialogObject **dop;
	int num_elements, max_object_width, cur_y, i, j;
	int focus_offset;

	flx_data->write_message(FLX_DATADDDEBUG,cur_function,"FlxDialogEvent: Doing update");
	dialog=static_cast<DIALOG *>(d_dialog_array);	

	/* determine how many elements the dialog will contain */
	num_elements=0;
	while((dop=d_object_list.item())){
		num_elements+=(*dop)->num_elements();
		d_object_list.advance();
	}
	d_object_list.rewind();

	/* Create an array of DIALOG structures representing that
		number of elements, plus 3 for an element to clear the
		screen, the frame, and the terminating null
		element. */
	if(dialog) delete dialog;
	dialog=new DIALOG[num_elements+3];
	/* When a dialog returns, we get an index into the array of dialog structures 
		which tells us which element caused it to return. We can use that index 
		with this array to get the actual dialog object corresponding to that
		element. */
	if(d_dialog_owners) delete d_dialog_owners;
	d_dialog_owners=new FlxDialogObject *[num_elements+3];
	for(i=0;i<num_elements+2;i++){
		dialog[i].proc=NULL;
		dialog[i].x=0;
		dialog[i].y=0;
		dialog[i].w=0;
		dialog[i].h=0;
		dialog[i].fg=makecol(255,255,255);
		dialog[i].bg=0;
		dialog[i].key=0;
		dialog[i].flags=0;
		dialog[i].d1=0;
		dialog[i].d2=0;
		dialog[i].dp=NULL;
		dialog[i].dp2=NULL;
		dialog[i].dp3=NULL;
		d_dialog_owners[i]=NULL;
	}	
	/* fill in the array with the appropriate values for each element */
	cur_y=static_cast<int>(flx_gui_font_height*.5);
	max_object_width=0;
	i=2;
	while(i<=num_elements+1){
		dop=d_object_list.item();
		(*dop)->build(&(dialog[i]),max_object_width,cur_y);
		/* this will place the input focus on the first object in the dialog
			that can accept some sort of user input (edit box, button, list,
			etc.) */
		if(d_focus_element==-1){
			focus_offset=(*dop)->offer_focus();
			if(focus_offset!=-1) d_focus_element=i+focus_offset;
		}
		cur_y+=static_cast<int>(flx_gui_font_height*.5);
		for(j=0;j<(*dop)->num_elements();j++){
			d_dialog_owners[i]=*dop;
			i++;
		}
		d_object_list.advance();
	}
	d_object_list.rewind();
	// create an initial element to clear the screen
	dialog[0].proc=d_clear_proc;

	// create the frame
	dialog[1].proc=d_agup_shadow_box_proc;
	dialog[1].w=max_object_width+2*flx_gui_font_width;
	dialog[1].h=cur_y;
	dialog[1].flags=0;
	dialog[1].x=(screen->w-dialog[1].w)/2;
	dialog[1].y=(screen->h-dialog[1].h)/2;

	// create the requisite null element at the end
	dialog[num_elements+2].proc=NULL;

	/* go back through the objects and adjust the x coordinate to reflect
		the alignment */
	while((dop=d_object_list.item())){
		(*dop)->do_alignment(max_object_width);
		d_object_list.advance();
	}
	d_object_list.rewind();

	/* now go back through the elements and adjust the x & y coordinates 
		of each to make them relative to the frame, rather than relative 
		to	the upper left corner of the screen */
	for(i=2;i<=num_elements+1;i++){
		dialog[i].x+=dialog[1].x+flx_gui_font_width;
		dialog[i].y+=dialog[1].y;
	}

	/* store the dialog array we've built so it can be accessed by the execute
		function */
	d_dialog_array=static_cast<void *>(dialog);
	
	return true;

} /* FlxDialogEvent::update */

/*****************************************************************************/

FLX_LINKAGE void FlxDialogEvent::execute(void){
	string cur_function="FlxDialogEvent::execute";
	int i;
	DIALOG *dialog;
	int return_status;
	
	flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
	this->do_generic_event_processing();

	/* If we call the dialog routines via a script, then the
	dialog will (usually) be automatically updated via the
	dependency hierarchy. If we call the routines from code,
	however, we need to explicitly update it.  This could also get
	triggered if a dialog event was created in a script, but no
	dialog objects were added to it. */
	if(!d_dialog_array){
		flx_data->write_message(FLX_DATAERROR,cur_function,"Can't display dialog; the dialog has no objects, or has not been updated.");
		return;
	}

	dialog=static_cast<DIALOG *>(d_dialog_array);

	/* Display the dialog and process user input; store the index of the
		element causing the dialog to close. */
	i=do_dialog(dialog,d_focus_element);
	if(i<0){
		d_exit_object="ESC";
	} else {
		/* This looks up the name of the object causing the
			dialog to close.  For all objects except
			regular buttons, this just is the name of the
			whole object. For regular button objects, it
			is the text of the particular button
			selected. */
		d_exit_object=d_dialog_owners[i]->exit_object();
	}
	/* If the element causing the box to close was a button with
		the text "Cancel", or the user pressed the escape key,
		then set the return status to FLX_DIALOG_CANCEL,
		otherwise set it to FLX_DIALOG_OK. The individual
		<update_value> functions use this flag to determine
		whether they should update their associated
		variable. In most cases they will only update given
		FLX_DIALOG_OK; the exception is regular buttons, which
		will always update their variable to indicate which
		button was pushed (if any). */
	if(d_exit_object=="Cancel" || d_exit_object=="ESC"){
		return_status=FLX_DIALOG_CANCEL;
	} else {
		return_status=FLX_DIALOG_OK;
	}
	while(d_object_list.item()){
		(*(d_object_list.item()))->update_value(return_status);
		d_object_list.advance();
	}
	d_object_list.rewind();
	
}

/*****************************************************************************/

bool NewDialogEvent(string *name){
  string cur_function="NewDialogEvent";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new DialogEvent '"+*name+"'");
  new FlxDialogEvent(*name);
  return true;

} /* NewDialogEvent */

/*****************************************************************************/

bool AddDialogObject(FlxDialogObject *dip){
    string cur_function="AddDialogObject";
	FlxDialogEvent *dep;

	// first, check the current event to make sure it can have dialog elements
	if((dep=dynamic_cast<FlxDialogEvent *>(flx_cur_event))){
    	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Adding object '"+dip->name()+"' to dialog '"+dep->name()+"'");
		dep->add_object(dip);
		flx_add_object_source(flx_cur_event,dip);
		flx_process_dependencies(flx_cur_event);
		return true;
	} else {
	    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Event '"+string(typeid(*flx_cur_event).name())+"' can't have dialog objects");
		return false;
	}
  
} /* AddDialogObject */

/*****************************************************************************/

void dialog_events_exit(void){

    agup_shutdown();

} /* dialog_events_exit */

/*****************************************************************************/

void flx_dialog_events_init(void){
    const AGUP_THEME *agup_theme=agup_theme_by_name("Win95");;

  agup_init(agup_theme);
  flx_add_command("DialogEvent",NewDialogEvent);
  flx_add_command("AddDialogObject",AddDialogObject);
  flx_add_scope_exit_hook("dialog_events_exit",dialog_events_exit);

  flx_cur_dialog_object=NULL;

} /* flx_dialog_events_init */

/*****************************************************************************/
