//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <stdlib.h>
//#include <search.h>
#include <allegro.h>
#include <flxbase.h>
#include <linkflx.h>
#include "flxgui\dialog_text.h"
#include "flxgui\dialog_buttons.h"
#include "flxgui\dialog_lists.h"
#include "flxgui\dialog_events.h"

/*****************************************************************************/

class FileDialog {
	/* These are static data members, common to all instances of
		the class. They allow us to have pointers to certain
		parameters of the file dialog box; all the dialog
		routines expect pointers, and so we can't use
		constants for this. */
	static long s_dialog_list_width;
	static long s_dialog_list_height;
	static string s_null_message;
	static string s_directories_text;
	static string s_files_text;
	static string s_ok_text;
	static string s_cancel_text;
	// these are regular data members
	string d_cur_path;
	bool d_new_file_dialog;
	FlxDialogText *d_message;
	string d_message_text;
	FlxDialogEdit *d_newfile;
	string d_newfile_text;
	FlxDialogText *d_dirlabel;
	FlxLinkedList<string> d_direntries;
	FlxDialogList *d_dirlist;
	string d_dir;
	FlxDialogText *d_filelabel;
	FlxLinkedList<string> d_fileentries;
	FlxDialogList *d_filelist;
	string d_file;
	FlxDialogButtonGroup *d_buttons;
	string d_button_choice;
	FlxDialogEvent *d_event;
public:
	FileDialog(const string &message,bool new_file_dialog);
	~FileDialog();
	int update_file_system_list(int type_flag);
	bool run(string &filename);
};

// see the explanation for these where they are declared above
long FileDialog::s_dialog_list_width=20;
long FileDialog::s_dialog_list_height=7;
string FileDialog::s_null_message="";
string FileDialog::s_directories_text="Directories";
string FileDialog::s_files_text="Files";
string FileDialog::s_ok_text="OK";
string FileDialog::s_cancel_text="Cancel";

/*****************************************************************************/

FileDialog::FileDialog(const string &message,bool new_file_dialog) : d_new_file_dialog(new_file_dialog), d_message_text(message) {
	
  flx_create_scalar_object("FILEDIALOGMESSAGESTRING",&d_message_text);
  flx_create_scalar_object("FILEDIALOGNEWFILETEXT",&d_newfile_text);
  flx_create_scalar_object("FILEDIALOGNULLMESSAGE",&s_null_message);
  flx_create_scalar_object("FILEDIALOGDIALOGLISTWIDTH",&s_dialog_list_width);
  flx_create_scalar_object("FILEDIALOGDIALOGLISTHEIGHT",&s_dialog_list_height);
  flx_create_scalar_object("FILEDIALOGDIRECTORIESTEXT",&s_directories_text);
  flx_create_scalar_object("FILEDIALOGDIR",&d_dir);
  flx_create_scalar_object("FILEDIALOGFILESTEXT",&s_files_text);
  flx_create_scalar_object("FILEDIALOGFILE",&d_file);
  flx_create_scalar_object("FILEDIALOGBUTTONCHOICE",&d_button_choice);

  d_message=new FlxDialogText("FILEDIALOGMESSAGE");
  d_message->set_text(&d_message_text);
  if(d_new_file_dialog){
    d_newfile=new FlxDialogEdit("FILEDIALOGEDIT");
    d_newfile->set_var_text(&d_newfile_text);
    d_newfile->set_text(&s_null_message);
    d_newfile->set_width(&s_dialog_list_width);
  }
  d_dirlabel=new FlxDialogText("FILEDIALOGDIRLABEL");
  d_dirlabel->set_text(&s_directories_text);
  d_dirlist=new FlxDialogList("FILEDIALOGDIRLIST");
  d_dirlist->set_var_text(&d_dir);
  d_dirlist->set_list_id(0);
  d_dirlist->set_width(&s_dialog_list_width);
  d_dirlist->set_height(&s_dialog_list_height);
  d_dirlist->set_close_on_click(flx_close_on_click_true);
  d_filelabel=new FlxDialogText("FILEDIALOGFILELABEL");
  d_filelabel->set_text(&s_files_text);
  d_filelist=new FlxDialogList("FILEDIALOGFILELIST");
  d_filelist->set_var_text(&d_file);
  d_filelist->set_list_id(1);
  d_filelist->set_width(&s_dialog_list_width);
  d_filelist->set_height(&s_dialog_list_height);
  if(!d_new_file_dialog){
    d_filelist->set_close_on_click(flx_close_on_click_true);
  }
  d_buttons=new FlxDialogButtonGroup("FILEDIALOGBUTTONS");
  d_buttons->set_var_text(&d_button_choice);
  d_buttons->set_type(FLX_DIALOG_BUTTON);
  d_buttons->set_group_id(0);
  d_buttons->add_button(&s_ok_text);
  d_buttons->add_button(&s_cancel_text);
  d_event=new FlxDialogEvent("FILEDIALOG");
  d_event->add_object(d_message);
  if(d_new_file_dialog) d_event->add_object(d_newfile);
  d_event->add_object(d_dirlabel);
  d_event->add_object(d_dirlist);
  d_event->add_object(d_filelabel);
  d_event->add_object(d_filelist);
  d_event->add_object(d_buttons);

} /* FileDialog::FileDialog */

/*****************************************************************************/

FileDialog::~FileDialog(void){
	
	delete d_message;
	if(d_new_file_dialog) delete d_newfile;
	delete d_dirlabel;
	delete d_dirlist;
	delete d_filelabel;
	delete d_filelist;
	delete d_buttons;
	delete d_event;

} /* FileDialog::~FileDialog */

/*****************************************************************************/

/* This fills up the appropriate dialog list with entries of the type indicated by
<type_flag> (either FLX_FS_DIRECTORIES or FLX_FS_FILES) from the directory
indicated by <d_cur_path> */
int FileDialog::update_file_system_list(int type_flag){
  string cur_function="FileDialog::update_file_system_list";
	FlxLinkedList<string> *list_entries;
	FlxDialogList *dialog_list;
	string *entry;
	int num_items;

	if(type_flag==FLX_FS_DIRECTORIES){
			list_entries=&d_direntries;
			dialog_list=d_dirlist;
	} else if(type_flag==FLX_FS_FILES){
			list_entries=&d_fileentries;
			dialog_list=d_filelist;
	} else {
	  flx_data->write_message(FLX_DATAERROR,cur_function,"FileDialog::update_file_system_list called with unknown type flag "+flx_convert_to_string(type_flag));  
	  return 0;
	}

	// get rid of the old items, if any
	list_entries->remove_all();
	dialog_list->remove_items();
	// get the new items
	flx_get_directory_entries(d_cur_path,*list_entries,type_flag);
	// insert the new items into the list
	num_items=0;
	while((entry=list_entries->item())){
		dialog_list->add_item(entry);
		num_items++;
		list_entries->advance();
	}
	list_entries->rewind();
	return num_items;

} /* FileDialog::update_file_system_list */

/*****************************************************************************/

bool FileDialog::run(string	&filename){
	string cur_function="FileDialog::run";
	string choice;
	bool continue_dialog;
	int	num_dir_items, num_file_items;

	flx_data->write_message(FLX_DATADEBUG,cur_function,"Displaying "+(d_new_file_dialog	? string("new file") : string("file selector"))+" dialog with initial file path '"+filename+"'");	
	d_cur_path=flx_extract_path(filename);
	flx_data->write_message(FLX_DATADDEBUG,cur_function,"Current path: "+d_cur_path);
	// get rid of	any	trailing directory separator
	if(d_cur_path[d_cur_path.size()-1]==flx_path_separator[0]	&& d_cur_path.size()>1)	d_cur_path.erase(d_cur_path.size()-1);
	continue_dialog=true;
	do{
		if(choice!=""){ // if	this isn't the initial update
			if(d_dir==".."){
				// delete the last directory from the path
				d_cur_path=flx_extract_path(d_cur_path);
				// get rid of any trailing directory separator
				if(d_cur_path[d_cur_path.size()-1]==flx_path_separator[0]) d_cur_path.erase(d_cur_path.size()-1);
			} else {
				d_cur_path+=flx_path_separator+d_dir;
			}
		}
		num_dir_items=update_file_system_list(FLX_FS_DIRECTORIES);
		num_file_items=update_file_system_list(FLX_FS_FILES);
		d_event->update();
		d_event->execute();
		choice=d_event->exit_object();
		if(choice=="OK"){
			/* For the select	file dialog, if	there are no
			regular	files in the directory and the user
			clicks "OK", then the selected file	entry will
			be garbage.	For	the	new	file dialog, if	the
			user doesn't enter anything, we	won't have a
			valid file name. When this happens,	we display
			an alert dialog	and	set	<choice> to	"",	to
			prevent	<d_cur_path> from being	updated	based on
			whatever is	selected in	the	list of
			directories. */
			if(d_new_file_dialog){
				if(d_newfile_text.size()){
					continue_dialog=false;
				}	else {
					flx_data->write_message(FLX_DATAERROR,cur_function,"Please enter a file	name first");
					choice="";
				}
			} else {
				if(num_file_items>0){
					continue_dialog=false;
				}	else {
					flx_data->write_message(FLX_DATAERROR,cur_function,"Please select a file first");
					choice="";
				}
			}
			/* For a file selector dialog, double-clicking on an item in the file list will	close
			the	box; for the new file dialog, we ignore	it */ 
		}	else if(choice=="FILEDIALOGFILELIST" &&	!d_new_file_dialog){
			continue_dialog=false;
		}	else if(choice=="Cancel" || choice=="ESC"){
			continue_dialog=false;
		}
	} while(continue_dialog);

	if(choice=="OK" || choice=="FILEDIALOGFILELIST"){
		filename=d_cur_path+flx_path_separator+(d_new_file_dialog ?	d_newfile_text : d_file);
		flx_data->write_message(FLX_DATADEBUG,cur_function,(d_new_file_dialog ?	string("Entered	filename") : string("Selected file"))+"	'"+filename+"'");
		return true;
	}	else {
		flx_data->write_message(FLX_DATADEBUG,cur_function,"Canceled file dialog");
		return false;
	}

} /* FileDialog::run */

/*****************************************************************************/

FLX_LINKAGE bool flx_do_file_dialog(const string &message,string &filename,bool new_file_dialog){
	FileDialog *file_dialog;
	bool return_val;
	
	flx_begin_scope("flx_file_dialog");
	file_dialog=new FileDialog(message,new_file_dialog);
	return_val=file_dialog->run(filename);
	flx_delete_scope("flx_file_dialog");
	return return_val;

} /* flx_do_file_dialog */

/*****************************************************************************/
