//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
//LIC//

#include <allegro.h>
#include "flxgui\dialog_objects.h"
#include "flxgui\dialog_alerts.h"

FLX_LINKAGE FlxDialogObject *flx_cur_dialog_object;
FLX_LINKAGE long *flx_default_dialog_alignment;
FLX_LINKAGE long *flx_dialog_alignment_left;
FLX_LINKAGE long *flx_dialog_alignment_center;
FLX_LINKAGE long *flx_dialog_alignment_right;

/*****************************************************************************/

void FlxDialogObject::do_alignment(int max_object_width){
  string cur_function="FlxDialogObject::do_alignment";
	int n, offset, i;
	DIALOG *dlg;

	if(*d_alignment==FLX_DIALOG_LEFT){
		// everything should be in the right place, don't do anything
		return;
	} else {
		/* check how many elements this object has */
		n=this->num_elements();

		/* determine how far to shift things, based on the right edge of the
			last element */
		dlg=static_cast<DIALOG *>(d_element_ptr);
		if(*d_alignment==FLX_DIALOG_CENTER){
			offset=(max_object_width-dlg[n-1].x-dlg[n-1].w)/2;
		} else if(*d_alignment==FLX_DIALOG_RIGHT){
			offset=max_object_width-dlg[n-1].x-dlg[n-1].w;
		}  else {
		  flx_data->write_message(FLX_DATAERROR,cur_function,"FlxDialogOjbect::do_alignment called with unknown alignment type "+flx_convert_to_string(*d_alignment));
		  return;
		}

		/* shift each element by that amount */
		for(i=0;i<n;i++){
			dlg[i].x=dlg[i].x+offset;
		}
	}

} /* FlxDialogObject::do_alignment */

/*****************************************************************************/

FLX_LINKAGE bool flx_type_convert(const string &s,FlxDialogObject *&dop){

  return flx_object_convert<FlxDialogObject>(s,dop,"FlxDialogObject");
} 

/*****************************************************************************/

bool SelectDialogObject(string *raw_argument){
/* Because the special dialog object 'default' should have all
   possible dialog properties (e.g., alignment), we
   can't implement it as an actual object, or modules wouldn't be able
   to add new dialog properties without changing the definition of
   the default object. Thus, the default object is implemented as a
   null pointer. Any routine that sets dialog properties then knows
   that if <flx_cur_dialog_object> is null, it should change the
   default value. The down side of this is that we can't pass in a
   null <FlxDialogObject *> to <SelectDialogObject>, because the
   <flx_type_convert> call to convert the raw argument to a dialog
   object would fail. Thus, we ask for the raw string argument and
   check if it is 'default'.  If so, we set <flx_cur_dialog_object>
   to null, otherwise we convert to a <FlxDialogObject *> and assign the
   result to <flx_cur_dialog_object>. */
  string cur_function="SelectDialogObject";
  FlxDialogObject *dop=NULL;

  if(*raw_argument=="default"){
	flx_data->write_message(FLX_DATASCRIPT,cur_function,"Selecting dialog object 'default'");
	flx_change_global_setting(&flx_cur_dialog_object,static_cast<FlxDialogObject *>(NULL),"flx_cur_dialog_object");
	return true;
  } else {
	if(flx_type_convert(*raw_argument,dop)){
      flx_data->write_message(FLX_DATASCRIPT,cur_function,"Selecting dialog object '"+dop->name()+"'");
      flx_change_global_setting(&flx_cur_dialog_object,dop,"flx_cur_dialog_object");
       return true;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Argument is the wrong type, skipping command");
      return false;
    }
  }

} /* SelectDialogObject */

/*****************************************************************************/

bool SetDialogObjectSize(long *size){
	string cur_function="Set"+flx_cur_script_command;
	string dimension;

	if(flx_cur_script_command=="DialogObjectWidth"){
		dimension="width";
	} else if(flx_cur_script_command=="DialogObjectHeight"){
		dimension="height";
	}
	if(flx_cur_dialog_object==NULL){
		flx_data->write_message(FLX_DATAERROR,cur_function,"Do dialog object is currently selected, so can't set its "+dimension);
		return false;
	} else {
		flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting "+dimension+" of dialog object '"+flx_cur_dialog_object->name()+"'");
		if(dimension=="width"){
			flx_cur_dialog_object->set_width(size);
		} else if(dimension=="height"){
			flx_cur_dialog_object->set_height(size);
		}
		return true;
	}

} /* SetDialogObjectSize */

/*****************************************************************************/

bool SetDialogObjectAlignment(long *alignment){
  string cur_function="SetDialogObjectAlignment";

  if(*alignment!=FLX_DIALOG_LEFT && *alignment!=FLX_DIALOG_CENTER && *alignment!=FLX_DIALOG_RIGHT){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Illegal setting for dialog object alignment");
    return false;
  }

  if(flx_cur_dialog_object==NULL){
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting default dialog object alignment attribute");
    flx_change_global_setting(&flx_default_dialog_alignment,alignment,"flx_default_dialog_alignment");
  } else {
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Setting dialog object alignment of '"+flx_cur_dialog_object->name()+"'");
	flx_cur_dialog_object->set_alignment(alignment);
  }
	return true;

} /* SetDialogObjectAlignment */

/*****************************************************************************/

void flx_dialog_objects_init(void){
  FlxScalarObject<long> *left;
  FlxScalarObject<long> *center;
  FlxScalarObject<long> *right;

  flx_add_command("SelectDialogObject",SelectDialogObject);
  flx_add_command("DialogObjectWidth",SetDialogObjectSize);
  flx_add_command("DialogObjectHeight",SetDialogObjectSize);
  flx_add_command("DialogObjectAlignment",SetDialogObjectAlignment);
  
  left=new FlxScalarObject<long>("LEFT");
  left->set_value(FLX_DIALOG_LEFT);
  flx_dialog_alignment_left=left->value();

  center=new FlxScalarObject<long>("CENTER");
  center->set_value(FLX_DIALOG_CENTER);
  flx_dialog_alignment_center=center->value();

  right=new FlxScalarObject<long>("RIGHT");
  right->set_value(FLX_DIALOG_RIGHT);
  flx_dialog_alignment_right=right->value();

  flx_default_dialog_alignment=flx_dialog_alignment_left;

} /* flx_dialog_objects_init */

/*****************************************************************************/
