//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#define FLX_INCLUDE_MODULE_HEADER
#include <flxgraphics.h>
#include <flxbase.h>

extern void flx_keyboard_init(void);
extern void flx_mouse_init(void);
extern void flx_joystick_init(void);
extern void flx_bitmap_fonts_init(void);
extern void flx_dialog_objects_init(void);
extern void flx_dialog_events_init(void);
extern void flx_dialog_text_init(void);
extern void flx_dialog_buttons_init(void);
extern void flx_dialog_lists_init(void);
extern void flx_dialog_bitmaps_init(void);
extern void flx_dialog_alerts_init(void);

extern bool clear_keyboard_buffer(void);

/*****************************************************************************/

/* In Windows the program tends to hang if you try to manipulate hardware from
the module initialization function; to avoid this, the following function gets
called immediately after the module has been loaded. */

void gui_init_callback(void){
	string cur_function="gui_init_callback";

	install_timer();

  if(install_keyboard()){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Couldn't initialize keyboard, aborting");
    abort_flxlab=true;
  } else {
    clear_keyboard_buffer();
    set_keyboard_rate(0,0); // disable auto-repeat (may not work on all platforms)
  }

  if(install_mouse()==-1){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Couldn't initialize mouse, aborting");
    abort_flxlab=true;
  } else {
    // mouse is initially not visible
    show_mouse(NULL);
  }

  if(install_joystick(JOY_TYPE_AUTODETECT)){
    flx_data->write_message(FLX_DATAINFO,cur_function,"No joystick detected, joystick routines disabled");
  } else {
    flx_data->write_message(FLX_DATAINFO,cur_function,"Joystick detected");
  }

} /* gui_init_callback */

/*****************************************************************************/

extern "C" {

  FLX_START_MODULE_INIT(gui)

	string cur_function="gui_module_init";

  flx_data->write_message(FLX_DATAINFO,cur_function,"Initializing GUI module");
  flx_keyboard_init();
  flx_mouse_init();
  flx_joystick_init();
  flx_bitmap_fonts_init();
  flx_dialog_objects_init();
  flx_dialog_events_init();
  flx_dialog_text_init();
  flx_dialog_buttons_init();
  flx_dialog_lists_init();
  flx_dialog_bitmaps_init();
  flx_dialog_alerts_init();
  flx_set_module_post_load_callback(gui_init_callback);

	FLX_END_MODULE_INIT

}

/*****************************************************************************/
