//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>

char break_key=17; // Control-Q
FlxLinkedList<char> keys_read;
string last_key, last_input;

/*****************************************************************************/

bool process_keyboard_buffer(void){
  char k;

  /* we don't do a log message from this function because it is potentially
     called a very large number of times in each trial */
  while(keypressed()){
    if((k=(readkey() & 0xff))==break_key){
      flx_force_exit=true;
      break;
    } else {
      keys_read.insert(k);
      last_key=k;
      if(k==scancode_to_ascii(KEY_ENTER)){ // ignore the enter key
	break;
      } else if(k=='\b') { // backspace erases the last character typed
	if(!last_input.empty()) last_input.erase(last_input.size()-1);
      } else { // otherwise, just add the character to the string
	last_input+=k;
      }
    }
  }
  return true;

} /* process_keyboard_buffer */

/*****************************************************************************/

bool clear_keyboard_buffer(void){
  string cur_function="clear_keyboard_buffer";

  flx_data->write_message(FLX_DATAHOOK,cur_function,"Clearing keyboard buffer");
  process_keyboard_buffer();
  keys_read.remove_all();
  last_key=last_input="";
  return true;

} /* clear_keyboard_buffer */

/*****************************************************************************/

#define KEYMATCH_ANY -1

class KeyCondition : public FlxCondition {
  int d_key_code;
  bool d_triggered;
public:
  KeyCondition(const string &name,int key_code) :  FlxCondition(name), d_key_code(key_code), d_triggered(false) {}
  ~KeyCondition(void) {}
  bool evaluate(void); 
  void reset(void){ d_triggered=false; }
};

bool KeyCondition::evaluate(void){
  char *next_key_ptr;

  if(d_triggered){
    return false;
  } else {
    // check if there's a matching key stored
    while((next_key_ptr=keys_read.item())){
      if(d_key_code==KEYMATCH_ANY || *next_key_ptr==d_key_code){
	keys_read.remove();
	d_triggered=true;
	break;
      }
      keys_read.advance();
    }
    keys_read.rewind();
    return d_triggered;
  }    
}

/*****************************************************************************/

FlxCondition *key_condition_parser(const string &keyword,int arg_count,string *arg_array){
  string cur_function="key_condition_parser";
  int key_code;
  string name;

  if(arg_count!=1){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad key condition");
    return NULL;
  } else {
    // parse the key specification
    if(arg_array[0]=="any"){
      key_code=KEYMATCH_ANY;
    } else if(arg_array[0]=="space"){
      key_code=' ';
    } else if(arg_array[0]=="enter"){
      /* ideally, this should ensure that we get the right result
	 on different platforms with different line separators */
      key_code=scancode_to_ascii(KEY_ENTER);
    } else if(arg_array[0]=="tab"){
      key_code='\t';
    } else if((arg_array[0]).size()==1){
      key_code=(arg_array[0])[0];
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad key condition");
      return NULL;
    }
    name=flx_unique_name();
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new key condition named '"+name+"'");
    return new KeyCondition(name,key_code);
  }

} /* key_condition_parser */

/*****************************************************************************/

void flx_keyboard_init(void){
  string cur_function="flx_keyboard_init";

  flx_create_scalar_object("key",&last_key);
  flx_create_scalar_object("input",&last_input);
  flx_add_condition_type("key",key_condition_parser);
  flx_add_event_hook("clear_keyboard_buffer",clear_keyboard_buffer,FLX_EVENT_HOOK_PRESESSION);
  flx_add_event_hook("clear_keyboard_buffer",clear_keyboard_buffer,FLX_EVENT_HOOK_PRETRIAL);
  flx_add_event_hook("clear_keyboard_buffer",clear_keyboard_buffer,FLX_EVENT_HOOK_POSTTRIAL);
  flx_add_event_hook("process_keyboard_buffer",process_keyboard_buffer,FLX_EVENT_HOOK_WITHINEVENT);

} /* flx_keyboard_init */

/*****************************************************************************/

