//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>

int old_mouse_state=0;
FlxLinkedList<int> clicks_read;
string last_mouse="NA";
long last_mouse_x=0;
long last_mouse_y=0;

/*****************************************************************************/

bool process_mouse_state(void){
  int i;

  /* basically, we store a click when a button bit changes from 0 to 1 */
  for(i=1;i<4;i*=2){
	  if(mouse_b&i && !(old_mouse_state&i)){
		  clicks_read.insert(i);
		  last_mouse_x=mouse_x;
		  last_mouse_y=mouse_y;
		  switch(i){
			  case 1:
				  last_mouse="left";
				  break;
			  case 2:
				  last_mouse="right";
				  break;
			  case 3:
				  last_mouse="center";
				  break;
		  }
		  break;
	  }
  }
  old_mouse_state=mouse_b;
  return true;

} /* process_mouse_state */

/*****************************************************************************/

bool clear_mouse_state(void){
  string cur_function="clear_mouse_state";

  flx_data->write_message(FLX_DATAHOOK,cur_function,"Clearing mouse state");
  clicks_read.remove_all();
  last_mouse="NA";
  return true;

} /* clear_mouse_state */

/*****************************************************************************/

#define BUTTONMATCH_ANY -1

class MouseCondition : public FlxCondition {
  int d_button_code;
  bool d_triggered;
public:
  MouseCondition(const string &name,int button_code) : FlxCondition(name), d_button_code(button_code), d_triggered(false) {}
  ~MouseCondition(void) {}
  bool evaluate(void); 
  void reset(void){ d_triggered=false; }
};

bool MouseCondition::evaluate(void){
  int *next_click_ptr;

  if(d_triggered){
    return false;
  } else {
    // check if there's a matching click stored
    while((next_click_ptr=clicks_read.item())){
      if(d_button_code==BUTTONMATCH_ANY || *next_click_ptr==d_button_code){
		clicks_read.remove();
		d_triggered=true;
		break;
      }
      clicks_read.advance();
    }
    clicks_read.rewind();    
    return d_triggered;
  }    
}

/*****************************************************************************/

FlxCondition *mouse_condition_parser(const string &keyword,int arg_count,string *arg_array){
  string cur_function="mouse_condition_parser";
  int button_code;
  string name;

  if(arg_count!=1){
    flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad mouse condition");
    return NULL;
  } else {
    // parse the button specification
    if(arg_array[0]=="any"){
      button_code=BUTTONMATCH_ANY;
    } else if(arg_array[0]=="left"){
      button_code=1;
    } else if(arg_array[0]=="right"){
      button_code=2;
    } else if(arg_array[0]=="center"){
      button_code=4;
    } else {
      flx_data->write_message(FLX_DATAERROR,cur_function,"Error at script line "+flx_convert_to_string(flx_cur_script_line)+": Bad mouse condition");
      return NULL;
    }
    name=flx_unique_name();
    flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Creating new mouse condition named '"+name+"'");
    return new MouseCondition(name,button_code);
  }

} /* mouse_condition_parser */

/*****************************************************************************/

class ShowMouseEvent : public FlxEvent {
public:
  ShowMouseEvent(const string &name) : FlxEvent(name) {}
  ~ShowMouseEvent(){}
  void execute(void);
};

void ShowMouseEvent::execute(void){
  string cur_function="ShowMouseEvent::execute";
  
  show_mouse(screen); 
  this->do_generic_event_processing();
  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
}

class HideMouseEvent : public FlxEvent {
public:
  HideMouseEvent(const string &name) : FlxEvent(name) {}
  ~HideMouseEvent(){}
  void execute(void);
};

void HideMouseEvent::execute(void){
  string cur_function="HideMouseEvent::execute";
  
  show_mouse(NULL); 
  this->do_generic_event_processing();
  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
}


/*****************************************************************************/

bool NewShowMouseEvent(string *name){
  string cur_function="NewShowMouseEvent";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new ShowMouseEvent '"+*name+"'");
  new ShowMouseEvent(*name);
  return true;

} /* NewShowMouseEvent */

/*****************************************************************************/

bool NewHideMouseEvent(string *name){
  string cur_function="NewHideMouseEvent";

  flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new HideMouseEvent '"+*name+"'");
  new HideMouseEvent(*name);
  return true;

} /* NewHideMouseEvent */

/*****************************************************************************/

void flx_mouse_init(void){
  string cur_function="mouse_init";

  flx_add_command("ShowMouseEvent",NewShowMouseEvent);
  flx_add_command("HideMouseEvent",NewHideMouseEvent);

  flx_create_scalar_object("mouse",&last_mouse);
  flx_create_scalar_object("mouse_x",&last_mouse_x);
  flx_create_scalar_object("mouse_y",&last_mouse_y);
  flx_add_condition_type("mouse",mouse_condition_parser);
  flx_add_event_hook("clear_mouse_state",clear_mouse_state,FLX_EVENT_HOOK_PRESESSION);
  flx_add_event_hook("clear_mouse_state",clear_mouse_state,FLX_EVENT_HOOK_PRETRIAL);
  flx_add_event_hook("clear_mouse_state",clear_mouse_state,FLX_EVENT_HOOK_POSTTRIAL);
  flx_add_event_hook("process_mouse_state",process_mouse_state,FLX_EVENT_HOOK_WITHINEVENT);

} /* flx_mouse_init */

/*****************************************************************************/
