//LIC// FLXLab v2.4 - A program for running psychology experiments.  
//LIC// Copyright (C) 2009 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <flxbase.h>

/*****************************************************************************/

bool Power(long *value,long *exponent){
  string cur_function="Power";
  long base, i;

  if(*exponent>=0){
    base=*value;
    *value=1;
    for(i=0;i<*exponent;i++){
      *value*=base;
    }
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Raising variable to the "+flx_convert_to_string(*exponent)+" power; new value is "+flx_convert_to_string(*value));
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Exponent for this command must be non-negative");
    return false;    
  }

} /* Power */

/*****************************************************************************/

bool Factorial(long *value){
  string cur_function="Factorial";
  long a;

  if(*value>0){
    a=*value-1;
    while(a>0){
      *value*=a;
      a--;
    }
    flx_data->write_message(FLX_DATASCRIPT,cur_function,"Computing factorial; new value is "+flx_convert_to_string(*value));
    return true;
  } else {
    flx_data->write_message(FLX_DATAERROR,cur_function,"Factorial requires a positive integer as an argument");
    return false;    
  }

} /* Factorial */

/*****************************************************************************/

void flx_sample_commands_init(void){
  string cur_function="flx_sample_commands_init";
  
  flx_add_command("Power",Power);
  flx_add_command("Factorial",Factorial);

} /* flx_sample_commands_init */

/*****************************************************************************/
